/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.entity;

import com.lidroid.xutils.http.client.util.URLEncodedUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicNameValuePair;

public class BodyParamsEntity
extends AbstractHttpEntity
implements Cloneable {
    protected byte[] content;
    private boolean dirty = true;
    private String charset = "UTF-8";
    private List<NameValuePair> params;

    public BodyParamsEntity() {
        this((String)null);
    }

    public BodyParamsEntity(String charset) {
        if (charset != null) {
            this.charset = charset;
        }
        this.setContentType("application/x-www-form-urlencoded");
        this.params = new ArrayList<NameValuePair>();
    }

    public BodyParamsEntity(List<NameValuePair> params) {
        this(params, null);
    }

    public BodyParamsEntity(List<NameValuePair> params, String charset) {
        if (charset != null) {
            this.charset = charset;
        }
        this.setContentType("application/x-www-form-urlencoded");
        this.params = params;
        this.refreshContent();
    }

    public BodyParamsEntity addParameter(String name, String value) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, value));
        this.dirty = true;
        return this;
    }

    public BodyParamsEntity addParams(List<NameValuePair> params) {
        this.params.addAll(params);
        this.dirty = true;
        return this;
    }

    private void refreshContent() {
        if (this.dirty) {
            try {
                this.content = URLEncodedUtils.format(this.params, this.charset).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                LogUtils.e(e.getMessage(), e);
            }
            this.dirty = false;
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        this.refreshContent();
        return this.content.length;
    }

    public InputStream getContent() throws IOException {
        this.refreshContent();
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        this.refreshContent();
        outStream.write(this.content);
        outStream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

