/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui.hex;

import com.coremedia.iso.gui.hex.JHexEditorASCII;
import com.coremedia.iso.gui.hex.JHexEditorHEX;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JHexEditor
extends JPanel
implements FocusListener,
AdjustmentListener,
MouseWheelListener {
    ByteBuffer buff;
    public int cursor;
    protected static Font font = new Font("Monospaced", 0, 12);
    protected int border = 2;
    public boolean DEBUG = false;
    private JScrollBar scrollBar;
    private int inicio = 0;
    private int numberOfVisibleLines = 10;

    public JHexEditor(ByteBuffer buff) {
        this.buff = buff;
        this.addMouseWheelListener(this);
        this.scrollBar = new JScrollBar(1);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(buff.limit() / this.getNumberOfVisibleLines());
        JPanel p1 = new JPanel(new BorderLayout(1, 1));
        p1.add((Component)new JHexEditorHEX(this), "Center");
        p1.add((Component)new Columnas(), "North");
        JPanel p2 = new JPanel(new BorderLayout(1, 1));
        p2.add((Component)new Filas(), "Center");
        p2.add((Component)new Caja(), "North");
        JPanel p3 = new JPanel(new BorderLayout(1, 1));
        p3.add((Component)this.scrollBar, "East");
        p3.add((Component)new JHexEditorASCII(this), "Center");
        p3.add((Component)new Caja(), "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(1, 1));
        panel.add((Component)p1, "Center");
        panel.add((Component)p2, "West");
        panel.add((Component)p3, "East");
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)panel, "Center");
    }

    public void paint(Graphics g) {
        FontMetrics fn = this.getFontMetrics(font);
        Rectangle rec = this.getBounds();
        this.numberOfVisibleLines = rec.height / fn.getHeight() - 2;
        int n = this.buff.limit() / 16;
        if (this.buff.limit() % 16 > 0) {
            ++n;
        }
        if (this.numberOfVisibleLines > n) {
            this.numberOfVisibleLines = n;
            this.inicio = 0;
        }
        this.scrollBar.setValues(this.getInicio(), this.getNumberOfVisibleLines(), 0, n);
        this.scrollBar.setValueIsAdjusting(true);
        super.paint(g);
    }

    protected void actualizaCursor() {
        int n = this.cursor / 16;
        if (this.buff.limit() % 16 > 0) {
            ++n;
        }
        if (n < this.inicio) {
            this.inicio = n;
        } else if (n >= this.inicio + this.numberOfVisibleLines) {
            this.inicio = n - this.numberOfVisibleLines + 2;
        }
        this.repaint();
    }

    protected int getInicio() {
        return this.inicio;
    }

    protected int getNumberOfVisibleLines() {
        if (this.DEBUG) {
            System.err.println("numberOfVisibleLines: " + this.numberOfVisibleLines);
        }
        return this.numberOfVisibleLines;
    }

    protected void filledCursor(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.fillRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void cuadro(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void printString(Graphics g, String s, int x, int y) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawString(s, (fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * (y + 1) - fn.getMaxDescent() + this.border);
    }

    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.inicio = e.getValue();
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.inicio += e.getUnitsToScroll();
        int n = this.buff.limit() / 16;
        if (this.inicio + this.numberOfVisibleLines >= (n += 4)) {
            this.inicio = n - this.numberOfVisibleLines;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: {
                if (this.cursor >= 16 * this.numberOfVisibleLines) {
                    this.cursor -= 16 * this.numberOfVisibleLines;
                }
                this.actualizaCursor();
                break;
            }
            case 34: {
                if (this.cursor < this.buff.limit() - 16 * this.numberOfVisibleLines) {
                    this.cursor += 16 * this.numberOfVisibleLines;
                }
                this.actualizaCursor();
                break;
            }
            case 35: {
                this.cursor = this.buff.limit() - 1;
                this.actualizaCursor();
                break;
            }
            case 36: {
                this.cursor = 0;
                this.actualizaCursor();
                break;
            }
            case 37: {
                if (this.cursor != 0) {
                    --this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 38: {
                if (this.cursor > 15) {
                    this.cursor -= 16;
                }
                this.actualizaCursor();
                break;
            }
            case 39: {
                if (this.cursor != this.buff.limit() - 1) {
                    ++this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 40: {
                if (this.cursor < this.buff.limit() - 16) {
                    this.cursor += 16;
                }
                this.actualizaCursor();
            }
        }
    }

    private class Filas
    extends JPanel {
        public Filas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = JHexEditor.this.getNumberOfVisibleLines();
            d.setSize((fn.stringWidth(" ") + 1) * 8 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            int ini = JHexEditor.this.getInicio();
            int fin = ini + JHexEditor.this.getNumberOfVisibleLines();
            int y = 0;
            for (int n = ini; n < fin; ++n) {
                if (n == JHexEditor.this.cursor / 16) {
                    JHexEditor.this.cuadro(g, 0, y, 8);
                }
                String s = "0000000000000" + Integer.toHexString(n);
                s = s.substring(s.length() - 8);
                JHexEditor.this.printString(g, s, 0, y++);
            }
        }
    }

    private class Caja
    extends JPanel {
        private Caja() {
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            d.setSize(fn.stringWidth(" ") + 1 + JHexEditor.this.border * 2 + 1, h + JHexEditor.this.border * 2 + 1);
            return d;
        }
    }

    private class Columnas
    extends JPanel {
        public Columnas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = 1;
            d.setSize((fn.stringWidth(" ") + 1) * 47 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            for (int n = 0; n < 16; ++n) {
                if (n == JHexEditor.this.cursor % 16) {
                    JHexEditor.this.cuadro(g, n * 3, 0, 2);
                }
                String s = "00" + Integer.toHexString(n);
                s = s.substring(s.length() - 2);
                JHexEditor.this.printString(g, s, n * 3, 0);
            }
        }
    }
}

