/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.aid;

import android.content.Context;
import android.util.Log;
import com.ta.utdid2.aid.AidRequester;
import com.ta.utdid2.aid.AidStorageController;
import com.ta.utdid2.android.utils.NetworkUtils;
import com.ta.utdid2.android.utils.StringUtils;
import com.ta.utdid2.android.utils.TimeUtils;
import com.ut.device.AidCallback;

public class AidManager {
    private static AidManager sAidManager = null;
    private static final String TAG = AidManager.class.getName();
    private static final int NUM_DAY_OUT_OF_DATE = 1;
    private Context mContext;

    public static synchronized AidManager getInstance(Context context) {
        if (sAidManager == null) {
            sAidManager = new AidManager(context);
        }
        return sAidManager;
    }

    private AidManager(Context context) {
        this.mContext = context;
    }

    public void requestAid(String appName, String token, String utdid, AidCallback callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"callback is null!");
            return;
        }
        if (this.mContext == null || StringUtils.isEmpty(appName) || StringUtils.isEmpty(token)) {
            Log.e((String)TAG, (String)("mContext:" + this.mContext + "; callback:" + callback + "; has appName:" + !StringUtils.isEmpty(appName) + "; has token:" + !StringUtils.isEmpty(token)));
            callback.onAidEventChanged(1002, "");
            return;
        }
        String aid = AidStorageController.getAidValueFromSP(this.mContext, appName, token);
        if (!StringUtils.isEmpty(aid) && TimeUtils.isUpToDate(AidStorageController.getAidGenTimeFromSP(this.mContext, appName, token), 1)) {
            callback.onAidEventChanged(1001, aid);
        } else if (NetworkUtils.isConnected(this.mContext)) {
            AidRequester aidHelper = AidRequester.getInstance(this.mContext);
            aidHelper.postRestAsync(appName, token, utdid, aid, callback);
        } else {
            callback.onAidEventChanged(1003, aid);
        }
    }

    public String getValue(String appName, String token, String utdid) {
        if (this.mContext == null || StringUtils.isEmpty(appName) || StringUtils.isEmpty(token)) {
            Log.e((String)TAG, (String)("mContext:" + this.mContext + "; has appName:" + !StringUtils.isEmpty(appName) + "; has token:" + !StringUtils.isEmpty(token)));
            return "";
        }
        String aid = AidStorageController.getAidValueFromSP(this.mContext, appName, token);
        if (!StringUtils.isEmpty(aid) && TimeUtils.isUpToDate(AidStorageController.getAidGenTimeFromSP(this.mContext, appName, token), 1)) {
            return aid;
        }
        if (NetworkUtils.isConnected(this.mContext)) {
            return this.genAidValue(appName, token, utdid);
        }
        return aid;
    }

    private synchronized String genAidValue(String appName, String token, String utdid) {
        if (this.mContext == null) {
            Log.e((String)TAG, (String)"no context!");
            return "";
        }
        String aidValue = "";
        if (NetworkUtils.isConnected(this.mContext)) {
            AidRequester aidHelper = AidRequester.getInstance(this.mContext);
            aidValue = aidHelper.postRest(appName, token, utdid, AidStorageController.getAidValueFromSP(this.mContext, appName, token));
        }
        AidStorageController.setAidValueToSP(this.mContext, appName, aidValue, token);
        return aidValue;
    }
}

