/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.core.persistent;

import com.ta.utdid2.core.persistent.MySharedPreferences;
import com.ta.utdid2.core.persistent.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParserException;

public class TransactionXMLFile {
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_WORLD_READABLE = 1;
    public static final int MODE_PRIVATE = 0;
    private final Object mSync = new Object();
    private File mPreferencesDir;
    private static final Object GLOBAL_COMMIT_LOCK = new Object();
    private HashMap<File, MySharedPreferencesImpl> sSharedPrefs = new HashMap();

    public TransactionXMLFile(String dir) {
        if (dir == null || dir.length() <= 0) {
            throw new RuntimeException("Directory can not be empty");
        }
        this.mPreferencesDir = new File(dir);
    }

    private File makeFilename(File base, String name) {
        if (name.indexOf(File.separatorChar) < 0) {
            return new File(base, name);
        }
        throw new IllegalArgumentException("File " + name + " contains a path separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mPreferencesDir;
        }
    }

    private File getSharedPrefsFile(String name) {
        return this.makeFilename(this.getPreferencesDir(), name + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MySharedPreferences getMySharedPreferences(String name, int mode) {
        MySharedPreferencesImpl sp;
        File f2 = this.getSharedPrefsFile(name);
        Object object = GLOBAL_COMMIT_LOCK;
        synchronized (object) {
            sp = this.sSharedPrefs.get(f2);
            if (sp != null && !sp.hasFileChanged()) {
                return sp;
            }
        }
        FileInputStream str = null;
        File backup = TransactionXMLFile.makeBackupFile(f2);
        if (backup.exists()) {
            f2.delete();
            backup.renameTo(f2);
        }
        if (!f2.exists() || !f2.canRead()) {
            // empty if block
        }
        HashMap map = null;
        if (f2.exists() && f2.canRead()) {
            try {
                str = new FileInputStream(f2);
                map = XmlUtils.readMapXml(str);
                str.close();
            }
            catch (XmlPullParserException e2) {
                try {
                    str = new FileInputStream(f2);
                    byte[] buf = new byte[str.available()];
                    str.read(buf);
                    String content = new String(buf, 0, buf.length, "UTF-8");
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e22) {
                    e22.printStackTrace();
                }
            }
            catch (FileNotFoundException e3) {
                e3.printStackTrace();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        }
        Object object2 = GLOBAL_COMMIT_LOCK;
        synchronized (object2) {
            if (sp != null) {
                sp.replace(map);
            } else {
                sp = this.sSharedPrefs.get(f2);
                if (sp == null) {
                    sp = new MySharedPreferencesImpl(f2, mode, map);
                    this.sSharedPrefs.put(f2, sp);
                }
            }
            return sp;
        }
    }

    private static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    private static final class MySharedPreferencesImpl
    implements MySharedPreferences {
        private final File mFile;
        private final File mBackupFile;
        private final int mMode;
        private Map mMap;
        private boolean hasChange = false;
        private static final Object mContent = new Object();
        private WeakHashMap<MySharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners;

        MySharedPreferencesImpl(File file, int mode, Map initialContents) {
            this.mFile = file;
            this.mBackupFile = TransactionXMLFile.makeBackupFile(file);
            this.mMode = mode;
            this.mMap = initialContents != null ? initialContents : new HashMap();
            this.mListeners = new WeakHashMap();
        }

        @Override
        public boolean checkFile() {
            File fTmp;
            return this.mFile != null && (fTmp = new File(this.mFile.getAbsolutePath())).exists();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHasChange(boolean hasChange) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                this.hasChange = hasChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasFileChanged() {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                return this.hasChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replace(Map newContents) {
            if (newContents != null) {
                MySharedPreferencesImpl mySharedPreferencesImpl = this;
                synchronized (mySharedPreferencesImpl) {
                    this.mMap = newContents;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerOnSharedPreferenceChangeListener(MySharedPreferences.OnSharedPreferenceChangeListener listener) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                this.mListeners.put(listener, mContent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterOnSharedPreferenceChangeListener(MySharedPreferences.OnSharedPreferenceChangeListener listener) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                this.mListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, ?> getAll() {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                return new HashMap(this.mMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(String key, String defValue) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                String v2 = (String)this.mMap.get(key);
                return v2 != null ? v2 : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(String key, int defValue) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                Integer v2 = (Integer)this.mMap.get(key);
                return v2 != null ? v2 : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(String key, long defValue) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                Long v2 = (Long)this.mMap.get(key);
                return v2 != null ? v2 : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(String key, float defValue) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                Float v2 = (Float)this.mMap.get(key);
                return v2 != null ? v2.floatValue() : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBoolean(String key, boolean defValue) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                Boolean v2 = (Boolean)this.mMap.get(key);
                return v2 != null ? v2 : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(String key) {
            MySharedPreferencesImpl mySharedPreferencesImpl = this;
            synchronized (mySharedPreferencesImpl) {
                return this.mMap.containsKey(key);
            }
        }

        @Override
        public MySharedPreferences.MyEditor edit() {
            return new EditorImpl();
        }

        private FileOutputStream createFileOutputStream(File file) {
            FileOutputStream str = null;
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e2) {
                File parent = file.getParentFile();
                if (!parent.mkdir()) {
                    return null;
                }
                try {
                    str = new FileOutputStream(file);
                }
                catch (FileNotFoundException e22) {
                    // empty catch block
                }
            }
            return str;
        }

        private boolean writeFileLocked() {
            if (this.mFile.exists()) {
                if (!this.mBackupFile.exists()) {
                    if (!this.mFile.renameTo(this.mBackupFile)) {
                        return false;
                    }
                } else {
                    this.mFile.delete();
                }
            }
            try {
                FileOutputStream str = this.createFileOutputStream(this.mFile);
                if (str == null) {
                    return false;
                }
                XmlUtils.writeMapXml(this.mMap, str);
                str.close();
                this.mBackupFile.delete();
                return true;
            }
            catch (XmlPullParserException e2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.mFile.exists() || !this.mFile.delete()) {
                // empty if block
            }
            return false;
        }

        public final class EditorImpl
        implements MySharedPreferences.MyEditor {
            private final Map<String, Object> mModified = new HashMap<String, Object>();
            private boolean mClear = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor putString(String key, String value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor putInt(String key, int value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor putLong(String key, long value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor putFloat(String key, float value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, Float.valueOf(value));
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor putBoolean(String key, boolean value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor remove(String key) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, this);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MySharedPreferences.MyEditor clear() {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mClear = true;
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean commit() {
                boolean returnValue;
                boolean hasListeners;
                ArrayList<String> keysModified = null;
                HashSet listeners = null;
                Object object = GLOBAL_COMMIT_LOCK;
                synchronized (object) {
                    boolean bl = hasListeners = MySharedPreferencesImpl.this.mListeners.size() > 0;
                    if (hasListeners) {
                        keysModified = new ArrayList<String>();
                        listeners = new HashSet(MySharedPreferencesImpl.this.mListeners.keySet());
                    }
                    EditorImpl editorImpl = this;
                    synchronized (editorImpl) {
                        if (this.mClear) {
                            MySharedPreferencesImpl.this.mMap.clear();
                            this.mClear = false;
                        }
                        for (Map.Entry<String, Object> e2 : this.mModified.entrySet()) {
                            String k2 = e2.getKey();
                            Object v2 = e2.getValue();
                            if (v2 == this) {
                                MySharedPreferencesImpl.this.mMap.remove(k2);
                            } else {
                                MySharedPreferencesImpl.this.mMap.put(k2, v2);
                            }
                            if (!hasListeners) continue;
                            keysModified.add(k2);
                        }
                        this.mModified.clear();
                    }
                    returnValue = MySharedPreferencesImpl.this.writeFileLocked();
                    if (returnValue) {
                        MySharedPreferencesImpl.this.setHasChange(true);
                    }
                }
                if (hasListeners) {
                    for (int i2 = keysModified.size() - 1; i2 >= 0; --i2) {
                        String key = (String)keysModified.get(i2);
                        for (MySharedPreferences.OnSharedPreferenceChangeListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onSharedPreferenceChanged(MySharedPreferencesImpl.this, key);
                        }
                    }
                }
                return returnValue;
            }
        }
    }
}

