/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilenceTrackImpl
implements Track {
    Track source;
    List<Sample> samples = new LinkedList<Sample>();
    TimeToSampleBox.Entry entry;

    public SilenceTrackImpl(Track ofType, long ms) {
        this.source = ofType;
        if ("mp4a".equals(ofType.getSampleDescriptionBox().getSampleEntry().getType())) {
            long numFrames = this.getTrackMetaData().getTimescale() * ms / 1000L / 1024L;
            long standZeit = this.getTrackMetaData().getTimescale() * ms / numFrames / 1000L;
            this.entry = new TimeToSampleBox.Entry(numFrames, standZeit);
            while (numFrames-- > 0L) {
                this.samples.add(new SampleImpl((ByteBuffer)ByteBuffer.wrap(new byte[]{33, 16, 4, 96, -116, 28}).rewind()));
            }
        } else {
            throw new RuntimeException("Tracks of type " + ofType.getClass().getSimpleName() + " are not supported");
        }
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return Collections.singletonList(this.entry);
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }
}

