/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.amap.api.col.de;
import com.amap.api.col.df;
import com.amap.api.col.dh;
import com.amap.api.col.dp;
import com.amap.api.col.j;
import com.amap.api.maps.AMapException;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.NaviPara;
import com.amap.api.maps.model.PoiPara;
import com.amap.api.maps.model.RoutePara;

public class AMapUtils {
    public static final int DRIVING_DEFAULT = 0;
    public static final int DRIVING_SAVE_MONEY = 1;
    public static final int DRIVING_SHORT_DISTANCE = 2;
    public static final int DRIVING_NO_HIGHWAY = 3;
    public static final int DRIVING_AVOID_CONGESTION = 4;
    public static final int DRIVING_NO_HIGHWAY_AVOID_SHORT_MONEY = 5;
    public static final int DRIVING_NO_HIGHWAY_AVOID_CONGESTION = 6;
    public static final int DRIVING_SAVE_MONEY_AVOID_CONGESTION = 7;
    public static final int DRIVING_NO_HIGHWAY_SAVE_MONEY_AVOID_CONGESTION = 8;
    public static final int BUS_TIME_FIRST = 0;
    public static final int BUS_MONEY_LITTLE = 1;
    public static final int BUS_TRANSFER_LITTLE = 2;
    public static final int BUS_WALK_LITTLE = 3;
    public static final int BUS_COMFORT = 4;
    public static final int BUS_NO_SUBWAY = 5;

    public static float calculateLineDistance(LatLng latLng, LatLng latLng2) {
        double d2 = 0.01745329251994329;
        double d3 = latLng.longitude;
        double d4 = latLng.latitude;
        double d5 = latLng2.longitude;
        double d6 = latLng2.latitude;
        d5 *= 0.01745329251994329;
        d6 *= 0.01745329251994329;
        double d7 = Math.sin(d3 *= 0.01745329251994329);
        double d8 = Math.sin(d4 *= 0.01745329251994329);
        double d9 = Math.cos(d3);
        double d10 = Math.cos(d4);
        double d11 = Math.sin(d5);
        double d12 = Math.sin(d6);
        double d13 = Math.cos(d5);
        double d14 = Math.cos(d6);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = d10 * d9;
        dArray[1] = d10 * d7;
        dArray[2] = d8;
        dArray2[0] = d14 * d13;
        dArray2[1] = d14 * d11;
        dArray2[2] = d12;
        double d15 = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
        return (float)(Math.asin(d15 / 2.0) * 1.27420015798544E7);
    }

    public static float calculateArea(LatLng latLng, LatLng latLng2) {
        double d2 = 6378137.0;
        double d3 = Math.sin(latLng.latitude * Math.PI / 180.0) - Math.sin(latLng2.latitude * Math.PI / 180.0);
        double d4 = (latLng2.longitude - latLng.longitude) / 360.0;
        if (d4 < 0.0) {
            d4 += 1.0;
        }
        return (float)(Math.PI * 2 * d2 * d2 * d3 * d4);
    }

    public static void getLatestAMapApp(Context context) {
        try {
            String string = "http://wap.amap.com/";
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10800000);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)string));
            a a2 = new a("glaa", context);
            a2.start();
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void openAMapNavi(NaviPara naviPara, Context context) throws AMapException {
        if (!AMapUtils.a(context)) throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        if (naviPara.getTargetPoint() == null) throw new AMapException(AMapException.ILLEGAL_AMAP_ARGUMENT);
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10800000);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)AMapUtils.a(naviPara, context)));
            intent.setPackage("com.autonavi.minimap");
            a a2 = new a("oan", context);
            a2.start();
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void openAMapPoiNearbySearch(PoiPara poiPara, Context context) throws AMapException {
        if (!AMapUtils.a(context)) throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        if (poiPara.getKeywords() == null || poiPara.getKeywords().trim().length() <= 0) throw new AMapException(AMapException.ILLEGAL_AMAP_ARGUMENT);
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10800000);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)AMapUtils.a(poiPara, context)));
            intent.setPackage("com.autonavi.minimap");
            a a2 = new a("oan", context);
            a2.start();
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        }
    }

    public static void openAMapDrivingRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 2);
    }

    public static void openAMapTransitRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 1);
    }

    public static void openAMapWalkingRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void a(RoutePara routePara, Context context, int n2) throws AMapException {
        if (!AMapUtils.a(context)) throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        if (!AMapUtils.a(routePara)) throw new AMapException(AMapException.ILLEGAL_AMAP_ARGUMENT);
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10800000);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)AMapUtils.b(routePara, context, n2)));
            intent.setPackage("com.autonavi.minimap");
            a a2 = new a("oan", context);
            a2.start();
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            throw new AMapException(AMapException.AMAP_NOT_SUPPORT);
        }
    }

    private static boolean a(RoutePara routePara) {
        return routePara.getStartPoint() != null && routePara.getEndPoint() != null && routePara.getStartName() != null && routePara.getStartName().trim().length() > 0 && routePara.getEndName() != null && routePara.getEndName().trim().length() > 0;
    }

    private static String a(NaviPara naviPara, Context context) {
        return String.format("androidamap://navi?sourceApplication=%s&lat=%f&lon=%f&dev=0&style=%d", df.b(context), naviPara.getTargetPoint().latitude, naviPara.getTargetPoint().longitude, naviPara.getNaviStyle());
    }

    private static String b(RoutePara routePara, Context context, int n2) {
        String string = String.format("androidamap://route?sourceApplication=%s&slat=%f&slon=%f&sname=%s&dlat=%f&dlon=%f&dname=%s&dev=0&t=%d", df.b(context), routePara.getStartPoint().latitude, routePara.getStartPoint().longitude, routePara.getStartName(), routePara.getEndPoint().latitude, routePara.getEndPoint().longitude, routePara.getEndName(), n2);
        if (n2 == 1) {
            string = string + "&m=" + routePara.getTransitRouteStyle();
        } else if (n2 == 2) {
            string = string + "&m=" + routePara.getDrivingRouteStyle();
        }
        return string;
    }

    private static String a(PoiPara poiPara, Context context) {
        String string = String.format("androidamap://arroundpoi?sourceApplication=%s&keywords=%s&dev=0", df.b(context), poiPara.getKeywords());
        if (poiPara.getCenter() != null) {
            string = string + "&lat=" + poiPara.getCenter().latitude + "&lon=" + poiPara.getCenter().longitude;
        }
        return string;
    }

    private static boolean a(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo("com.autonavi.minimap", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
            return false;
        }
        return packageInfo != null;
    }

    static class a
    extends Thread {
        String a = "";
        Context b;

        public a(String string, Context context) {
            this.a = string;
            if (context != null) {
                this.b = context.getApplicationContext();
            }
        }

        public void run() {
            if (this.b != null) {
                try {
                    dp dp2 = new dp.a(this.a, "3.3.3", j.d).a(new String[]{"com.amap.api.maps"}).a();
                    dh.a(this.b, dp2);
                    this.interrupt();
                }
                catch (de de2) {
                    de2.printStackTrace();
                }
            }
        }
    }
}

