/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.graphics.Point;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.MapProjection;
import com.autonavi.amap.mapcore.interfaces.CameraUpdateFactoryDelegate;

public final class CameraUpdateFactory {
    public static CameraUpdate zoomIn() {
        return new CameraUpdate(CameraUpdateFactoryDelegate.zoomIn());
    }

    public static CameraUpdate zoomOut() {
        return new CameraUpdate(CameraUpdateFactoryDelegate.zoomOut());
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.scrollBy(f2, f3));
    }

    public static CameraUpdate zoomTo(float f2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.zoomTo(f2));
    }

    public static CameraUpdate zoomBy(float f2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.zoomBy(f2));
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.zoomBy(f2, point));
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.newCameraPosition(cameraPosition));
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.newLatLng(latLng));
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.newLatLngZoom(latLng, f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.newLatLngBounds(latLngBounds, n2));
    }

    public static CameraUpdate changeLatLng(LatLng latLng) {
        IPoint iPoint = new IPoint();
        MapProjection.lonlat2Geo(latLng.longitude, latLng.latitude, iPoint);
        return new CameraUpdate(CameraUpdateFactoryDelegate.changeGeoCenter(iPoint));
    }

    public static CameraUpdate changeBearing(float f2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.changeBearing(f2 % 360.0f));
    }

    public static CameraUpdate changeBearingGeoCenter(float f2, IPoint iPoint) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.changeBearingGeoCenter(f2 % 360.0f, iPoint));
    }

    public static CameraUpdate changeTilt(float f2) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.changeTilt(f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        return new CameraUpdate(CameraUpdateFactoryDelegate.newLatLngBoundsWithSize(latLngBounds, n2, n3, n4));
    }
}

