/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.amap.api.col.cf;
import com.amap.api.col.ch;
import com.amap.api.col.j;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class b {
    protected List<Marker> stationMarkers = new ArrayList<Marker>();
    protected List<Polyline> allPolyLines = new ArrayList<Polyline>();
    protected Marker startMarker;
    protected Marker endMarker;
    protected LatLng startPoint;
    protected LatLng endPoint;
    protected AMap mAMap;
    private Context a;
    private Bitmap b;
    private Bitmap c;
    private Bitmap d;
    private Bitmap e;
    private Bitmap f;
    protected boolean nodeIconVisible = true;

    public b(Context context) {
        this.a = context;
    }

    public void removeFromMap() {
        if (this.startMarker != null) {
            this.startMarker.remove();
        }
        if (this.endMarker != null) {
            this.endMarker.remove();
        }
        for (Marker object : this.stationMarkers) {
            object.remove();
        }
        for (Polyline polyline : this.allPolyLines) {
            polyline.remove();
        }
        this.a();
    }

    private void a() {
        if (this.b != null) {
            this.b.recycle();
            this.b = null;
        }
        if (this.c != null) {
            this.c.recycle();
            this.c = null;
        }
        if (this.d != null) {
            this.d.recycle();
            this.d = null;
        }
        if (this.e != null) {
            this.e.recycle();
            this.e = null;
        }
        if (this.f != null) {
            this.f.recycle();
            this.f = null;
        }
    }

    protected BitmapDescriptor getStartBitmapDescriptor() {
        return this.a(this.b, "amap_start.png");
    }

    protected BitmapDescriptor getEndBitmapDescriptor() {
        return this.a(this.c, "amap_end.png");
    }

    protected BitmapDescriptor getBusBitmapDescriptor() {
        return this.a(this.d, "amap_bus.png");
    }

    protected BitmapDescriptor getWalkBitmapDescriptor() {
        return this.a(this.e, "amap_man.png");
    }

    protected BitmapDescriptor getDriveBitmapDescriptor() {
        return this.a(this.f, "amap_car.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapDescriptor a(Bitmap bitmap, String string) {
        InputStream inputStream = null;
        try {
            inputStream = cf.a(this.a).open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            bitmap = ch.a(bitmap, j.a);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        bitmap.recycle();
        return bitmapDescriptor;
    }

    protected void addStartAndEndMarker() {
        this.startMarker = this.mAMap.addMarker(new MarkerOptions().position(this.startPoint).icon(this.getStartBitmapDescriptor()).title("\u8d77\u70b9"));
        this.endMarker = this.mAMap.addMarker(new MarkerOptions().position(this.endPoint).icon(this.getEndBitmapDescriptor()).title("\u7ec8\u70b9"));
    }

    public void zoomToSpan() {
        if (this.startPoint != null) {
            if (this.mAMap == null) {
                return;
            }
            try {
                LatLngBounds latLngBounds = this.getLatLngBounds();
                this.mAMap.animateCamera(CameraUpdateFactory.newLatLngBounds(latLngBounds, 50));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        builder.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        builder.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        return builder.build();
    }

    public void setNodeIconVisibility(boolean bl2) {
        try {
            this.nodeIconVisible = bl2;
            if (this.stationMarkers != null && this.stationMarkers.size() > 0) {
                for (int i2 = 0; i2 < this.stationMarkers.size(); ++i2) {
                    this.stationMarkers.get(i2).setVisible(bl2);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void addStationMarker(MarkerOptions markerOptions) {
        if (markerOptions == null) {
            return;
        }
        Marker marker = this.mAMap.addMarker(markerOptions);
        if (marker != null) {
            this.stationMarkers.add(marker);
        }
    }

    protected void addPolyLine(PolylineOptions polylineOptions) {
        if (polylineOptions == null) {
            return;
        }
        Polyline polyline = this.mAMap.addPolyline(polylineOptions);
        if (polyline != null) {
            this.allPolyLines.add(polyline);
        }
    }

    protected float getRouteWidth() {
        return 18.0f;
    }

    protected int getWalkColor() {
        return Color.parseColor((String)"#6db74d");
    }

    protected int getBusColor() {
        return Color.parseColor((String)"#537edc");
    }

    protected int getDriveColor() {
        return Color.parseColor((String)"#537edc");
    }
}

