/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.amap.api.col.db;
import com.amap.api.col.dc;
import com.amap.api.col.dw;
import com.amap.api.navi.AMapHudViewListener;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.MyNaviListener;
import com.amap.api.navi.model.AMapLaneInfo;
import com.amap.api.navi.model.AMapNaviCross;
import com.amap.api.navi.model.AMapNaviInfo;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.AMapNaviTrafficFacilityInfo;
import com.amap.api.navi.model.AimLessModeCongestionInfo;
import com.amap.api.navi.model.AimLessModeStat;
import com.amap.api.navi.model.NaviInfo;
import com.amap.api.navi.view.AutoNaviHudMirrorImage;
import com.autonavi.tbt.TrafficFacilityInfo;
import com.autonavi.wtbt.CarLocation;

public class AMapHudView
extends FrameLayout
implements View.OnClickListener,
View.OnTouchListener,
MyNaviListener {
    static final int[] hud_imgActions = new int[]{2130837535, 2130837535, 2130837535, 2130837536, 2130837537, 2130837538, 2130837539, 2130837540, 2130837541, 2130837542, 2130837525, 2130837526, 2130837527, 2130837528, 2130837529, 2130837530, 2130837531, 2130837532, 2130837533, 2130837534};
    private static final long delayMillis = 2000L;
    AMapHudViewListener aMapHudVewListener;
    boolean isLandscape = false;
    private Context mContext;
    private View frameLayout;
    private AMapNavi mAMapNavi;
    private int mWidth = 480;
    private int mHeight = 800;
    private int hudMode = 1;
    private boolean isHudMenu = true;
    private Handler disappearHudHandler = new Handler();
    private TextView restDistanceTime;
    private String distanceTimeTextStr;
    private TextView limitSpeedTextView;
    private CheckBox mMirrorModeCheckBox;
    private AutoNaviHudMirrorImage autonaviHudMirrorImage;
    private TextView nextRoadNameText;
    private TextView restDistanceText;
    private ImageView roadsignimg;
    private TextView nextRoadDistanceText;
    private View title_btn_goback;
    private View mHudMirrorTitle;
    private Runnable disappearHudTitleRunnable = new Runnable(){

        public void run() {
            try {
                try {
                    AMapHudView.this.loadHideHudTitleAnimation();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                dw.b(throwable, "AMapHudView", "disappearHudTitleRunnable");
            }
        }
    };
    private CompoundButton.OnCheckedChangeListener mOnCheckedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton compoundButton, boolean bl2) {
            try {
                if (AMapHudView.this.autonaviHudMirrorImage == null) {
                    return;
                }
                if (bl2) {
                    AMapHudView.this.hudMode = 2;
                } else {
                    AMapHudView.this.hudMode = 1;
                }
                AMapHudView.this.setCheckBoxAndMirrorImageState(bl2);
                AMapHudView.this.removeCallbacks();
                AMapHudView.this.disappearHudHandler.postDelayed(AMapHudView.this.disappearHudTitleRunnable, 2000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                dw.b(throwable, "AMapHudView", "mOnCheckedChangeListener");
            }
        }
    };
    private String nextRoadNameTextStr;
    private String restDistanceTextStr;
    private SpannableString nextRoadDisTextSpannableStr = null;
    private int resId;

    public AMapHudView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        try {
            this.init(context);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs, int defStyle) ");
        }
    }

    public AMapHudView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        try {
            this.init(context);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs) ");
        }
    }

    public AMapHudView(Context context) {
        super(context);
        this.init(context);
    }

    public int getHudViewMode() {
        return this.hudMode;
    }

    public void setHudViewMode(int n2) {
        try {
            this.hudMode = n2;
            this.setCheckBoxAndMirrorImageState(this.hudMode == 2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "setHudViewMode(int mode)");
        }
    }

    public boolean getHudMenuEnabled() {
        return this.isHudMenu;
    }

    public void setHudMenuEnabled(Boolean bl2) {
        this.isHudMenu = bl2;
    }

    public final void onCreate(Bundle bundle) {
    }

    public final void onResume() {
    }

    public final void onPause() {
    }

    public final void onDestroy() {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onDestroy()");
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
    }

    public void setHudViewListener(AMapHudViewListener aMapHudViewListener) {
        this.aMapHudVewListener = aMapHudViewListener;
    }

    private void init(Context context) {
        try {
            this.mContext = context;
            this.mAMapNavi = AMapNavi.getInstance(context);
            this.isLandscape = ((Activity)this.getContext()).getRequestedOrientation() == 0 || this.getResources().getConfiguration().orientation == 2;
            this.frameLayout = this.isLandscape ? dc.a((Activity)this.getContext(), 2130903041, null) : dc.a((Activity)this.getContext(), 2130903040, null);
            this.addView(this.frameLayout);
            this.initResolution();
            this.initWidget();
            this.mAMapNavi.addAMapNaviListener(this);
            this.onNaviInfoUpdate(this.mAMapNavi.getNaviInfo());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "init(Context context)");
        }
    }

    private void initResolution() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        this.mWidth = displayMetrics.widthPixels;
        this.mHeight = displayMetrics.heightPixels;
    }

    public boolean onTouchHudMirrorEvent(MotionEvent motionEvent) {
        try {
            if (!this.isHudMenu) {
                return true;
            }
            this.loadShowHudTitleAnimation();
            this.removeCallbacks();
            this.disappearHudHandler.postDelayed(this.disappearHudTitleRunnable, 2000L);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onTouchHudMirrorEvent(MotionEvent event)");
            return true;
        }
    }

    private void loadShowHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 8) {
            Animation animation = dc.a(this.mContext, 2130968576);
            this.mHudMirrorTitle.setVisibility(0);
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    private void initWidget() {
        this.mHudMirrorTitle = this.frameLayout.findViewById(2131296263);
        this.autonaviHudMirrorImage = (AutoNaviHudMirrorImage)this.frameLayout.findViewById(2131296256);
        this.mMirrorModeCheckBox = (CheckBox)this.frameLayout.findViewById(2131296265);
        this.nextRoadNameText = (TextView)this.frameLayout.findViewById(2131296257);
        this.restDistanceText = (TextView)this.frameLayout.findViewById(2131296260);
        this.roadsignimg = (ImageView)this.frameLayout.findViewById(2131296258);
        this.nextRoadDistanceText = (TextView)this.frameLayout.findViewById(2131296259);
        this.title_btn_goback = this.frameLayout.findViewById(2131296264);
        this.restDistanceTime = (TextView)this.frameLayout.findViewById(2131296261);
        this.limitSpeedTextView = (TextView)this.frameLayout.findViewById(2131296262);
        this.getScreenInfo();
        this.setWidgetListener();
        this.updateHudWidgetContent();
    }

    private void getScreenInfo() {
        if (this.autonaviHudMirrorImage == null) {
            return;
        }
        this.autonaviHudMirrorImage.mWidth = this.mWidth;
        this.autonaviHudMirrorImage.mHeight = this.mHeight - 50;
    }

    private void updateHudWidgetContent() {
        if (this.nextRoadNameText != null) {
            this.nextRoadNameText.setText((CharSequence)this.nextRoadNameTextStr);
        }
        if (this.nextRoadDistanceText != null) {
            this.nextRoadDistanceText.setText((CharSequence)this.nextRoadDisTextSpannableStr);
        }
        if (this.restDistanceText != null) {
            this.restDistanceText.setText((CharSequence)this.restDistanceTextStr);
        }
        if (this.restDistanceTime != null) {
            this.restDistanceTime.setText((CharSequence)this.distanceTimeTextStr);
        }
        if (this.roadsignimg != null && this.resId != 0 && this.resId != 1) {
            Drawable drawable = dc.a().getDrawable(hud_imgActions[this.resId]);
            this.roadsignimg.setBackgroundDrawable(drawable);
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.invalidate();
                this.autonaviHudMirrorImage.postInvalidate();
            }
        }
    }

    private void setWidgetListener() {
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setAMapHudView(this);
            this.setOnTouchListener(this);
        }
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setOnCheckedChangeListener(this.mOnCheckedChangeListener);
        }
        if (this.title_btn_goback != null) {
            this.title_btn_goback.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void removeCallbacks() {
        if (this.disappearHudHandler != null && this.disappearHudTitleRunnable != null) {
            this.disappearHudHandler.removeCallbacks(this.disappearHudTitleRunnable);
        }
    }

    private void setCheckBoxAndMirrorImageState(boolean bl2) {
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setChecked(bl2);
        }
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setMirrorState(bl2);
            this.autonaviHudMirrorImage.invalidate();
            this.autonaviHudMirrorImage.postInvalidate();
        }
    }

    private void loadHideHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 0) {
            Animation animation = dc.a(this.mContext, 2130968577);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AMapHudView.this.mHudMirrorTitle.setVisibility(8);
                }
            });
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    private boolean isHudMirror() {
        return this.hudMode == 2;
    }

    protected void onConfigurationChanged(Configuration configuration) {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
                this.autonaviHudMirrorImage = null;
            }
            this.removeAllViews();
            this.frameLayout = this.getResources().getConfiguration().orientation == 2 ? dc.a((Activity)this.getContext(), 2130903041, null) : dc.a((Activity)this.getContext(), 2130903040, null);
            this.addView(this.frameLayout);
            this.initResolution();
            this.initWidget();
            this.getScreenInfo();
            this.onNaviInfoUpdate(this.mAMapNavi.getNaviInfo());
            this.setCheckBoxAndMirrorImageState(this.isHudMirror());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onConfigurationChanged(Configuration newConfig)");
        }
        super.onConfigurationChanged(configuration);
    }

    private void updateHudUI(NaviInfo naviInfo) {
        try {
            if (naviInfo == null) {
                return;
            }
            this.nextRoadNameTextStr = naviInfo.m_NextRoadName;
            this.restDistanceTextStr = db.b(naviInfo.getPathRetainDistance());
            this.nextRoadDisTextSpannableStr = this.switchStrFromMeter(naviInfo.m_SegRemainDis);
            this.resId = naviInfo.m_Icon;
            this.distanceTimeTextStr = db.c(naviInfo.m_RouteRemainTime);
            if (this.mAMapNavi.getNaviSetting().isMonitorCameraEnabled() && this.mAMapNavi.getEngineType() == 0 && naviInfo.getCameraDistance() > 0 && this.limitSpeedTextView != null && naviInfo.m_CameraSpeed > 0) {
                this.limitSpeedTextView.setText((CharSequence)("" + naviInfo.m_CameraSpeed));
                this.limitSpeedTextView.setVisibility(0);
            } else if (naviInfo.m_CameraSpeed == 0 && this.limitSpeedTextView != null) {
                this.limitSpeedTextView.setVisibility(8);
            }
            this.updateHudWidgetContent();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "updateHudUI(NaviInfo naviInfo)");
        }
    }

    private SpannableString switchStrFromMeter(int n2) {
        if (n2 >= 1000) {
            float f2 = (float)n2 / 1000.0f;
            f2 = (float)Math.round(f2 * 10.0f) / 10.0f;
            return this.getSpanableString(this.mContext, f2 + "", "\u516c\u91cc");
        }
        return this.getSpanableString(this.mContext, n2 + "", "\u7c73");
    }

    private SpannableString getSpanableString(Context context, String string, String string2) {
        SpannableString spannableString = new SpannableString((CharSequence)(string + string2));
        int n2 = db.a(context, 60);
        int n3 = db.a(context, 30);
        int n4 = 33;
        int n5 = 0;
        int n6 = string.length();
        spannableString.setSpan((Object)new AbsoluteSizeSpan(n2), n5, n6, n4);
        spannableString.setSpan((Object)new ForegroundColorSpan(-1), n5, n6, n4);
        n5 = n6;
        spannableString.setSpan((Object)new AbsoluteSizeSpan(n3), n5, n6 += string2.length(), n4);
        spannableString.setSpan((Object)new ForegroundColorSpan(-1), n5, n6, n4);
        return spannableString;
    }

    public void onClick(View view) {
        try {
            if (this.title_btn_goback == view && this.aMapHudVewListener != null) {
                this.aMapHudVewListener.onHudViewCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onClick(View v)");
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        try {
            this.onTouchHudMirrorEvent(motionEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onTouch(View arg0, MotionEvent arg1)");
        }
        return false;
    }

    public void onInitNaviFailure() {
    }

    public void onInitNaviSuccess() {
    }

    public void onStartNavi(int n2) {
    }

    public void onTrafficStatusUpdate() {
    }

    public void onLocationChange(AMapNaviLocation aMapNaviLocation) {
    }

    public void onGetNavigationText(int n2, String string) {
    }

    public void onEndEmulatorNavi() {
    }

    public void onArriveDestination() {
    }

    public void onCalculateRouteSuccess() {
    }

    public void onCalculateRouteFailure(int n2) {
    }

    public void onReCalculateRouteForYaw() {
    }

    public void onReCalculateRouteForTrafficJam() {
    }

    public void onArrivedWayPoint(int n2) {
    }

    public void onGpsOpenStatus(boolean bl2) {
    }

    public void onNaviInfoUpdate(NaviInfo naviInfo) {
        try {
            this.updateHudUI(naviInfo);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "AMapHudView", "onNaviInfoUpdate(NaviInfo naviinfo)");
        }
    }

    public void OnUpdateTrafficFacility(TrafficFacilityInfo trafficFacilityInfo) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo aMapNaviTrafficFacilityInfo) {
    }

    public void showCross(AMapNaviCross aMapNaviCross) {
    }

    public void hideCross() {
    }

    public void showLaneInfo(AMapLaneInfo[] aMapLaneInfoArray, byte[] byArray, byte[] byArray2) {
    }

    public void hideLaneInfo() {
    }

    public void onCalculateMultipleRoutesSuccess(int[] nArray) {
    }

    public void notifyParallelRoad(int n2) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo[] aMapNaviTrafficFacilityInfoArray) {
    }

    public void updateAimlessModeStatistics(AimLessModeStat aimLessModeStat) {
    }

    public void updateAimlessModeCongestionInfo(AimLessModeCongestionInfo aimLessModeCongestionInfo) {
    }

    public void carProjectionChange(CarLocation carLocation) {
    }

    public void onNaviInfoUpdated(AMapNaviInfo aMapNaviInfo) {
    }
}

