/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi;

import android.content.Context;
import android.os.PowerManager;
import com.amap.api.col.db;
import com.amap.api.col.dw;
import com.amap.api.navi.ITBTControl;

public class NaviSetting {
    PowerManager.WakeLock wl;
    boolean mIsMonitorCameraEnabled = true;
    private boolean trafficStatusUpdateEnabled = false;
    private boolean trafficInfoUpdateEnabled = true;
    private boolean mCameraInfoUpdateEnabled = true;
    private boolean screenAlwaysBright = false;
    private ITBTControl mTbtControl;

    public NaviSetting(Context context, ITBTControl iTBTControl) {
        try {
            Context context2 = context.getApplicationContext();
            this.mTbtControl = iTBTControl;
            if (context2 != null) {
                PowerManager powerManager = (PowerManager)context2.getSystemService("power");
                this.wl = powerManager.newWakeLock(10, "autonavi");
                this.wl.setReferenceCounted(false);
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "NaviSetting", "NaviSetting(Context context, TBTControl tbtControl)");
        }
    }

    public boolean isTrafficStatusUpdateEnabled() {
        return this.trafficStatusUpdateEnabled;
    }

    public void setTrafficStatusUpdateEnabled(boolean bl2) {
        this.trafficStatusUpdateEnabled = bl2;
        if (this.mTbtControl != null) {
            this.mTbtControl.setTrafficStatusUpdateEnabled(this.trafficStatusUpdateEnabled);
        }
    }

    public boolean isTrafficInfoUpdateEnabled() {
        return this.trafficInfoUpdateEnabled;
    }

    public void setTrafficInfoUpdateEnabled(boolean bl2) {
        this.trafficInfoUpdateEnabled = bl2;
        if (this.mTbtControl != null) {
            this.mTbtControl.setTrafficInfoUpdateEnabled(this.trafficInfoUpdateEnabled);
        }
    }

    public boolean isCameraInfoUpdateEnabled() {
        return this.mCameraInfoUpdateEnabled;
    }

    public void setCameraInfoUpdateEnabled(boolean bl2) {
        this.mCameraInfoUpdateEnabled = bl2;
        if (this.mTbtControl != null) {
            this.mTbtControl.setCameraInfoUpdateEnabled(this.mCameraInfoUpdateEnabled);
        }
    }

    boolean isMonitorCameraEnabled() {
        return this.mIsMonitorCameraEnabled;
    }

    public void setMonitorCameraEnabled(boolean bl2) {
        this.mIsMonitorCameraEnabled = bl2;
    }

    public boolean isScreenAlwaysBright() {
        return this.screenAlwaysBright;
    }

    public void setScreenAlwaysBright(boolean bl2) {
        this.screenAlwaysBright = bl2;
        try {
            if (this.screenAlwaysBright) {
                this.wl.acquire();
            } else if (this.wl.isHeld()) {
                this.wl.release();
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "NaviSetting", "setScreenAlwaysBright(boolean isAlwaysBright)");
        }
    }

    public void destroy() {
        try {
            if (this.wl.isHeld()) {
                this.wl.release();
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "NaviSetting", "destroy()");
        }
    }
}

