/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.amap.api.col.db;
import com.amap.api.col.dc;
import com.amap.api.col.dw;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;

public class CameraOverlay {
    private BitmapDescriptor mBitmapDescriptor = null;
    private Marker mCameraMarker;
    private LatLng mLastLatLng = null;

    public CameraOverlay() {
        try {
            this.mBitmapDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837507));
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "CameraOverlay", "CameraOverlay()");
        }
    }

    public CameraOverlay(BitmapDescriptor bitmapDescriptor) {
        this.mBitmapDescriptor = bitmapDescriptor;
    }

    public void draw(AMap aMap, LatLng latLng) {
        try {
            if (aMap == null) {
                return;
            }
            if (this.mCameraMarker == null) {
                this.mCameraMarker = aMap.addMarker(new MarkerOptions().position(latLng).anchor(0.5f, 0.5f).icon(this.mBitmapDescriptor));
            } else {
                if (latLng.equals(this.mLastLatLng)) {
                    return;
                }
                this.mCameraMarker.setPosition(latLng);
                this.mCameraMarker.setVisible(true);
            }
            this.mLastLatLng = latLng;
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "CameraOverlay", "draw(AMap aMap, LatLng latLng)");
        }
    }

    public void setVisible(boolean bl2) {
        if (this.mCameraMarker != null) {
            this.mCameraMarker.setVisible(bl2);
        }
    }

    public void destroy() {
        if (this.mCameraMarker != null) {
            this.mCameraMarker.remove();
        }
        if (this.mBitmapDescriptor != null) {
            this.mBitmapDescriptor.recycle();
        }
        this.mBitmapDescriptor = null;
    }

    public void setCameraBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            this.mBitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        }
    }
}

