/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.amap.api.col.dc;

public class DirectionView
extends ImageView {
    private Bitmap mDirectionBitmap;
    private Matrix mDirectionMatrix = new Matrix();
    private Paint mPaint;
    private PaintFlagsDrawFilter mPaintFlagsDrawFilter;

    public DirectionView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initPaint();
    }

    public DirectionView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initPaint();
    }

    public DirectionView(Context context) {
        super(context);
        this.initPaint();
    }

    private void initPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mDirectionBitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837596);
        }
        this.mPaintFlagsDrawFilter = new PaintFlagsDrawFilter(0, 3);
    }

    public void setRotate(float f2) {
        if (this.mDirectionBitmap == null) {
            return;
        }
        this.mDirectionMatrix.setRotate(f2, (float)this.mDirectionBitmap.getWidth() / 2.0f, (float)this.mDirectionBitmap.getHeight() / 2.0f);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDirectionBitmap.getWidth(), (int)this.mDirectionBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.setDrawFilter((DrawFilter)this.mPaintFlagsDrawFilter);
        if (this.mDirectionBitmap != null && this.mDirectionMatrix != null) {
            canvas.drawBitmap(this.mDirectionBitmap, this.mDirectionMatrix, this.mPaint);
        }
        this.setImageBitmap(bitmap);
    }

    public void recycleResource() {
        if (this.mDirectionBitmap != null) {
            this.mDirectionBitmap.recycle();
            this.mDirectionBitmap = null;
        }
    }

    public Bitmap getDirectionBitmap() {
        return this.mDirectionBitmap;
    }

    public void setDirectionBitmap(Bitmap bitmap) {
        this.mDirectionBitmap = bitmap;
    }
}

