/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.amap.api.col.dc;
import com.amap.api.navi.AMapNaviView;

public class DriveWayView
extends ImageView {
    private int driveWayWidth = 0;
    private int driveWayHeight = 0;
    private int driveWaySize = 0;
    private int[] driveWayBackgroundId = new int[]{2130837545, 2130837546, 2130837547, 2130837548, 2130837549, 2130837550, 2130837551, 2130837552, 2130837553, 2130837554, 2130837555, 2130837556, 2130837557, 2130837558, 2130837559};
    private int[] driveWayForegroundId = new int[]{2130837560, 2130837561, 2130837547, 2130837564, 2130837549, 2130837567, 2130837551, 2130837552, 2130837573, 2130837554, 2130837555, 2130837556, 2130837557, 2130837582, 2130837559};
    private AMapNaviView mAMapNaviView = null;
    private Bitmap[] driveWayBitMaps = null;
    private Bitmap[] driveWayBitMapBgs = null;
    private int height;
    private int width;

    public DriveWayView(Context context) {
        super(context);
    }

    public DriveWayView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public DriveWayView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    public int getDriveWayWidth() {
        return this.driveWayWidth;
    }

    public void setAMapNaviView(AMapNaviView aMapNaviView) {
        this.mAMapNaviView = aMapNaviView;
    }

    public void loadDriveWayBitmap(byte[] byArray, byte[] byArray2) {
        int n2;
        this.driveWaySize = this.parseDriveWaySize(byArray);
        if (this.driveWaySize == 0) {
            return;
        }
        this.driveWayBitMapBgs = new Bitmap[this.driveWaySize];
        this.driveWayBitMaps = new Bitmap[this.driveWaySize];
        for (n2 = 0; n2 < this.driveWaySize; ++n2) {
            this.driveWayBitMapBgs[n2] = BitmapFactory.decodeResource((Resources)dc.a(), (int)this.driveWayBackgroundId[byArray[n2]]);
            this.driveWayBitMaps[n2] = this.isComplexLane(byArray[n2]) ? this.complexBitmap(byArray[n2], byArray2[n2]) : (this.isThisLaneRecommended(byArray2[n2]) ? BitmapFactory.decodeResource((Resources)dc.a(), (int)this.driveWayForegroundId[byArray2[n2]]) : this.driveWayBitMapBgs[n2]);
        }
        if (this.driveWayBitMapBgs[n2 - 1] != null) {
            this.driveWayWidth = this.driveWayBitMapBgs[n2 - 1].getWidth();
            this.driveWayHeight = this.driveWayBitMapBgs[n2 - 1].getHeight();
        }
        this.height = this.driveWayHeight;
        this.width = this.driveWayWidth * this.driveWaySize;
        this.setImageBitmap(this.produceFinalBitmap());
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
    }

    private int parseDriveWaySize(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != 15) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    private boolean isThisLaneRecommended(byte by2) {
        return by2 != 15;
    }

    private boolean isComplexLane(int n2) {
        return n2 == 14 || n2 == 2 || n2 == 4 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 12 || n2 == 6 || n2 == 7;
    }

    private Bitmap complexBitmap(int n2, int n3) {
        Bitmap bitmap = null;
        if (n2 == 10) {
            if (n3 == 0) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837576);
            } else if (n3 == 8) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837577);
            }
        } else if (n2 == 9) {
            if (n3 == 0) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837574);
            } else if (n3 == 5) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837575);
            }
        } else if (n2 == 2) {
            if (n3 == 0) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837562);
            } else if (n3 == 1) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837563);
            }
        } else if (n2 == 4) {
            if (n3 == 0) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837565);
            } else if (n3 == 3) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837566);
            }
        } else if (n2 == 6) {
            if (n3 == 1) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837568);
            } else if (n3 == 3) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837569);
            }
        } else if (n2 == 7) {
            if (n3 == 0) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837570);
            } else if (n3 == 1) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837571);
            } else if (n3 == 3) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837572);
            }
        } else if (n2 == 11) {
            if (n3 == 5) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837579);
            } else if (n3 == 1) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837578);
            }
        } else if (n2 == 12) {
            if (n3 == 8) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837581);
            } else if (n3 == 3) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837580);
            }
        } else if (n2 == 14) {
            if (n3 == 1) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837583);
            } else if (n3 == 5) {
                bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837584);
            }
        }
        if (bitmap == null) {
            bitmap = BitmapFactory.decodeResource((Resources)dc.a(), (int)this.driveWayBackgroundId[n2]);
        }
        return bitmap;
    }

    public void setDefaultTopMargin(int n2) {
        if (this.mAMapNaviView == null) {
            return;
        }
        int n3 = 0;
        int n4 = 10;
        n3 = this.mAMapNaviView.isOrientationLandscape() ? n2 + n4 : (this.mAMapNaviView.isShowRoadEnlarge() ? n2 * 3 / 8 - (this.driveWayHeight >> 1) : n2 + n4);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.setMargins(0, n3, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void recycleResource() {
        for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
            if (this.driveWayBitMaps[i2] != null) {
                this.driveWayBitMaps[i2].recycle();
                this.driveWayBitMaps[i2] = null;
            }
            if (this.driveWayBitMapBgs[i2] == null) continue;
            this.driveWayBitMapBgs[i2].recycle();
            this.driveWayBitMapBgs[i2] = null;
        }
        this.driveWaySize = 0;
    }

    Bitmap produceFinalBitmap() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
            if (this.driveWayBitMaps[i2] == null) continue;
            canvas.drawBitmap(this.driveWayBitMaps[i2], (float)(i2 * this.driveWayWidth), 0.0f, null);
        }
        return bitmap;
    }

    public int getDriveWaySize() {
        return this.driveWaySize;
    }

    public int getDriveWayBgHeight() {
        return this.driveWayHeight;
    }
}

