/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.amap.api.col.db;
import com.amap.api.col.dc;
import com.amap.api.col.dw;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.Circle;
import com.amap.api.maps.model.CircleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.NavigateArrow;
import com.amap.api.maps.model.NavigateArrowOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.AMapNaviException;
import com.amap.api.navi.model.AMapNaviPath;
import com.amap.api.navi.model.AMapNaviStep;
import com.amap.api.navi.model.AMapTrafficStatus;
import com.amap.api.navi.model.NaviLatLng;
import com.amap.api.navi.model.RouteOverlayOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteOverLay {
    private Bitmap startBitmap;
    private Bitmap endBitmap;
    private Bitmap wayBitmap;
    private BitmapDescriptor startBitmapDescriptor;
    private BitmapDescriptor endBitmapDescriptor;
    private BitmapDescriptor wayPointBitmapDescriptor;
    private Marker startMarker;
    private List<Marker> wayMarkers;
    private Marker endMarker;
    private BitmapDescriptor arrowOnRoute = null;
    private BitmapDescriptor normalRoute = null;
    private BitmapDescriptor unknownTraffic = null;
    private BitmapDescriptor smoothTraffic = null;
    private BitmapDescriptor slowTraffic = null;
    private BitmapDescriptor jamTraffic = null;
    private BitmapDescriptor veryJamTraffic = null;
    private List<Polyline> mTrafficColorfulPolylines = new ArrayList<Polyline>();
    private RouteOverlayOptions mRouteOverlayOptions = null;
    private float mWidth = 40.0f;
    private AMapNaviPath mAMapNaviPath = null;
    private Polyline mDefaultPolyline;
    private AMap aMap;
    private Context mContext;
    private List<LatLng> mLatLngsOfPath;
    private Polyline guideLink = null;
    private List<Circle> gpsCircles = null;
    private boolean emulateGPSLocationVisibility = true;
    private NavigateArrow naviArrow = null;
    private boolean isTrafficLine = true;
    private List<Polyline> mCustomPolylines = new ArrayList<Polyline>();

    public RouteOverLay(AMap aMap, AMapNaviPath aMapNaviPath, Context context) {
        this.mContext = context;
        this.init(aMap, aMapNaviPath);
    }

    public float getWidth() {
        return this.mWidth;
    }

    public void setWidth(float f2) throws AMapNaviException {
        if (f2 <= 0.0f) {
            throw new AMapNaviException("\u975e\u6cd5\u53c2\u6570-\u5bbd\u5ea6\u5fc5\u987b>0");
        }
        this.mWidth = f2;
    }

    public RouteOverlayOptions getRouteOverlayOptions() {
        return this.mRouteOverlayOptions;
    }

    public void setRouteOverlayOptions(RouteOverlayOptions routeOverlayOptions) {
        this.mRouteOverlayOptions = routeOverlayOptions;
        if (routeOverlayOptions != null && routeOverlayOptions.getNormalRoute() != null) {
            this.normalRoute = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getNormalRoute());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getArrowOnTrafficRoute() != null) {
            this.arrowOnRoute = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getArrowOnTrafficRoute());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getUnknownTraffic() != null) {
            this.unknownTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getUnknownTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getSmoothTraffic() != null) {
            this.smoothTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getSmoothTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getSlowTraffic() != null) {
            this.slowTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getSlowTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getJamTraffic() != null) {
            this.jamTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getJamTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getVeryJamTraffic() != null) {
            this.veryJamTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getVeryJamTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getLineWidth() > 0.0f) {
            this.mWidth = routeOverlayOptions.getLineWidth();
        }
    }

    public AMapNaviPath getAMapNaviPath() {
        return this.mAMapNaviPath;
    }

    public void setAMapNaviPath(AMapNaviPath aMapNaviPath) {
        this.mAMapNaviPath = aMapNaviPath;
    }

    @Deprecated
    public void setRouteInfo(AMapNaviPath aMapNaviPath) {
        this.mAMapNaviPath = aMapNaviPath;
    }

    private void init(AMap aMap, AMapNaviPath aMapNaviPath) {
        try {
            this.aMap = aMap;
            this.mAMapNaviPath = aMapNaviPath;
            this.normalRoute = BitmapDescriptorFactory.fromAsset("custtexture.png");
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "init(AMap amap, AMapNaviPath aMapNaviPath)");
        }
        this.arrowOnRoute = BitmapDescriptorFactory.fromAsset("custtexture_aolr.png");
        this.smoothTraffic = BitmapDescriptorFactory.fromAsset("custtexture_green.png");
        this.unknownTraffic = BitmapDescriptorFactory.fromAsset("custtexture_no.png");
        this.slowTraffic = BitmapDescriptorFactory.fromAsset("custtexture_slow.png");
        this.jamTraffic = BitmapDescriptorFactory.fromAsset("custtexture_bad.png");
        this.veryJamTraffic = BitmapDescriptorFactory.fromAsset("custtexture_grayred.png");
    }

    public void addToMap() {
        try {
            Object object;
            int n2;
            Object object2;
            Object object32;
            if (this.aMap == null) {
                return;
            }
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
                this.mDefaultPolyline = null;
            }
            if (this.mWidth == 0.0f || this.mAMapNaviPath == null) {
                return;
            }
            if (this.naviArrow != null) {
                this.naviArrow.setVisible(false);
            }
            List<NaviLatLng> list = null;
            list = this.mAMapNaviPath.getCoordList();
            if (list == null) {
                return;
            }
            int n3 = list.size();
            this.mLatLngsOfPath = new ArrayList<LatLng>(n3);
            for (Object object32 : list) {
                object2 = new LatLng(object32.getLatitude(), object32.getLongitude(), false);
                this.mLatLngsOfPath.add((LatLng)object2);
            }
            if (this.mLatLngsOfPath.size() == 0) {
                return;
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
            this.mDefaultPolyline = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).setCustomTexture(this.normalRoute).width(this.mWidth));
            this.mDefaultPolyline.setVisible(true);
            Object object4 = null;
            object32 = null;
            object2 = null;
            if (this.mAMapNaviPath.getStartPoint() != null && this.mAMapNaviPath.getEndPoint() != null) {
                object4 = new LatLng(this.mAMapNaviPath.getStartPoint().getLatitude(), this.mAMapNaviPath.getStartPoint().getLongitude());
                object32 = new LatLng(this.mAMapNaviPath.getEndPoint().getLatitude(), this.mAMapNaviPath.getEndPoint().getLongitude());
                object2 = this.mAMapNaviPath.getWayPoint();
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            if (this.wayMarkers != null && this.wayMarkers.size() > 0) {
                for (n2 = 0; n2 < this.wayMarkers.size(); ++n2) {
                    object = this.wayMarkers.get(n2);
                    if (object == null) continue;
                    ((Marker)object).remove();
                    object = null;
                }
            }
            if (this.startBitmap == null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object4).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837638))));
            } else if (this.startBitmapDescriptor != null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object4).icon(this.startBitmapDescriptor));
            }
            if (object2 != null && object2.size() > 0) {
                n2 = object2.size();
                if (this.wayMarkers == null) {
                    this.wayMarkers = new ArrayList<Marker>(n2);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    NaviLatLng naviLatLng = (NaviLatLng)object.next();
                    LatLng latLng = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude());
                    Marker marker = null;
                    if (this.wayBitmap == null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837645))));
                    } else if (this.wayPointBitmapDescriptor != null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(this.wayPointBitmapDescriptor));
                    }
                    this.wayMarkers.add(marker);
                }
            }
            if (this.endBitmap == null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object32).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837520))));
            } else if (this.endBitmapDescriptor != null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object32).icon(this.endBitmapDescriptor));
            }
            if (this.isTrafficLine) {
                this.setTrafficLine(this.isTrafficLine);
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "addToMap()");
        }
    }

    public void drawGuideLink(LatLng latLng, LatLng latLng2, boolean bl2) {
        if (bl2) {
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>(2);
            arrayList.add(latLng);
            arrayList.add(latLng2);
            if (this.guideLink == null) {
                this.guideLink = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth / 3.0f).setDottedLine(true));
            } else {
                this.guideLink.setPoints(arrayList);
            }
            this.guideLink.setVisible(true);
        } else if (this.guideLink != null) {
            this.guideLink.setVisible(false);
        }
    }

    public void drawEmulateGPSLocation(Vector<String> vector) {
        try {
            if (this.gpsCircles == null) {
                this.gpsCircles = new ArrayList<Circle>(vector.size());
            } else {
                for (Circle object : this.gpsCircles) {
                    object.remove();
                }
                this.gpsCircles.clear();
            }
            for (String string : vector) {
                String[] stringArray = string.split(",");
                if (stringArray == null || stringArray.length < 11) continue;
                LatLng latLng = new LatLng(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                Circle circle = this.aMap.addCircle(new CircleOptions().center(latLng).radius(1.5).strokeWidth(0.0f).fillColor(-65536));
                this.gpsCircles.add(circle);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dw.b(exception, "RouteOverLay", "drawEmulateGPSLocation(Vector<String> gpsData)");
        }
    }

    public void setEmulateGPSLocationVisible() {
        if (this.gpsCircles != null) {
            this.emulateGPSLocationVisibility = !this.emulateGPSLocationVisibility;
            for (Circle circle : this.gpsCircles) {
                circle.setVisible(this.emulateGPSLocationVisibility);
            }
        }
    }

    public void setStartPointBitmap(Bitmap bitmap) {
        this.startBitmap = bitmap;
        if (this.startBitmap != null) {
            this.startBitmapDescriptor = BitmapDescriptorFactory.fromBitmap(this.startBitmap);
        }
    }

    public void setWayPointBitmap(Bitmap bitmap) {
        this.wayBitmap = bitmap;
        if (this.wayBitmap != null) {
            this.wayPointBitmapDescriptor = BitmapDescriptorFactory.fromBitmap(this.wayBitmap);
        }
    }

    public void setEndPointBitmap(Bitmap bitmap) {
        this.endBitmap = bitmap;
        if (this.endBitmap != null) {
            this.endBitmapDescriptor = BitmapDescriptorFactory.fromBitmap(this.endBitmap);
        }
    }

    public void removeFromMap() {
        try {
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.setVisible(false);
            }
            if (this.startMarker != null) {
                this.startMarker.setVisible(false);
            }
            if (this.wayMarkers != null) {
                for (Marker object : this.wayMarkers) {
                    object.setVisible(false);
                }
            }
            if (this.endMarker != null) {
                this.endMarker.setVisible(false);
            }
            if (this.naviArrow != null) {
                this.naviArrow.remove();
            }
            if (this.guideLink != null) {
                this.guideLink.setVisible(false);
            }
            if (this.gpsCircles != null) {
                for (Circle circle : this.gpsCircles) {
                    circle.setVisible(false);
                }
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "removeFromMap()");
        }
    }

    private void clearTrafficLineAndInvisibleOriginalLine() {
        int n2;
        if (this.mTrafficColorfulPolylines.size() > 0) {
            for (n2 = 0; n2 < this.mTrafficColorfulPolylines.size(); ++n2) {
                if (this.mTrafficColorfulPolylines.get(n2) == null) continue;
                this.mTrafficColorfulPolylines.get(n2).remove();
            }
        }
        this.mTrafficColorfulPolylines.clear();
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setVisible(false);
        }
        if (this.mCustomPolylines.size() > 0) {
            for (n2 = 0; n2 < this.mCustomPolylines.size(); ++n2) {
                if (this.mCustomPolylines.get(n2) == null) continue;
                this.mCustomPolylines.get(n2).setVisible(false);
            }
        }
    }

    private void colorWayUpdate(List<AMapTrafficStatus> list) {
        if (this.aMap == null) {
            return;
        }
        if (this.mLatLngsOfPath == null || this.mLatLngsOfPath.size() <= 0) {
            return;
        }
        if (list == null || list.size() <= 0) {
            return;
        }
        this.clearTrafficLineAndInvisibleOriginalLine();
        int n2 = 0;
        LatLng latLng = this.mLatLngsOfPath.get(0);
        LatLng latLng2 = null;
        double d2 = 0.0;
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        Polyline polyline = null;
        for (int i2 = 0; i2 < this.mLatLngsOfPath.size() && n2 < list.size(); ++i2) {
            AMapTrafficStatus aMapTrafficStatus = list.get(n2);
            latLng2 = this.mLatLngsOfPath.get(i2);
            NaviLatLng naviLatLng = new NaviLatLng(latLng.latitude, latLng.longitude);
            NaviLatLng naviLatLng2 = new NaviLatLng(latLng2.latitude, latLng2.longitude);
            double d3 = db.a(naviLatLng, naviLatLng2);
            if ((d2 += d3) > (double)(aMapTrafficStatus.getLength() + 1)) {
                double d4 = d3 - (d2 - (double)aMapTrafficStatus.getLength());
                NaviLatLng naviLatLng3 = db.a(naviLatLng, naviLatLng2, d4);
                LatLng latLng3 = new LatLng(naviLatLng3.getLatitude(), naviLatLng3.getLongitude());
                arrayList.add(latLng3);
                latLng = latLng3;
                --i2;
            } else {
                arrayList.add(latLng2);
                latLng = latLng2;
            }
            if (!(d2 >= (double)aMapTrafficStatus.getLength()) && i2 != this.mLatLngsOfPath.size() - 1) continue;
            if (n2 == list.size() - 1 && i2 < this.mLatLngsOfPath.size() - 1) {
                ++i2;
                while (i2 < this.mLatLngsOfPath.size()) {
                    LatLng latLng4 = this.mLatLngsOfPath.get(i2);
                    arrayList.add(latLng4);
                    ++i2;
                }
            }
            ++n2;
            switch (aMapTrafficStatus.getStatus()) {
                case 0: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.unknownTraffic));
                    break;
                }
                case 1: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.smoothTraffic));
                    break;
                }
                case 2: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.slowTraffic));
                    break;
                }
                case 3: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.jamTraffic));
                    break;
                }
                case 4: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.veryJamTraffic));
                    break;
                }
            }
            this.mTrafficColorfulPolylines.add(polyline);
            arrayList.clear();
            arrayList.add(latLng);
            d2 = 0.0;
        }
        polyline = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).width(this.mWidth).setCustomTexture(this.arrowOnRoute));
        this.mTrafficColorfulPolylines.add(polyline);
    }

    public void zoomToSpan() {
        this.zoomToSpan(100);
    }

    public void zoomToSpan(int n2) {
        try {
            if (this.mAMapNaviPath == null) {
                return;
            }
            CameraUpdate cameraUpdate = CameraUpdateFactory.newLatLngBounds(this.mAMapNaviPath.getBoundsForPath(), n2);
            this.aMap.animateCamera(cameraUpdate, 1000L, null);
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "zoomToSpan()");
        }
    }

    public void destroy() {
        try {
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
            }
            this.mAMapNaviPath = null;
            if (this.arrowOnRoute != null) {
                this.arrowOnRoute.recycle();
            }
            if (this.smoothTraffic != null) {
                this.smoothTraffic.recycle();
            }
            if (this.unknownTraffic != null) {
                this.unknownTraffic.recycle();
            }
            if (this.slowTraffic != null) {
                this.slowTraffic.recycle();
            }
            if (this.jamTraffic != null) {
                this.jamTraffic.recycle();
            }
            if (this.veryJamTraffic != null) {
                this.veryJamTraffic.recycle();
            }
            if (this.startBitmap != null) {
                this.startBitmap.recycle();
            }
            if (this.endBitmap != null) {
                this.endBitmap.recycle();
            }
            if (this.wayBitmap != null) {
                this.wayBitmap.recycle();
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "destroy()");
        }
    }

    public void drawArrow(List<NaviLatLng> list) {
        try {
            if (list == null) {
                this.naviArrow.setVisible(false);
                return;
            }
            int n2 = list.size();
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>(n2);
            for (NaviLatLng naviLatLng : list) {
                LatLng latLng = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude(), false);
                arrayList.add(latLng);
            }
            if (this.naviArrow == null) {
                this.naviArrow = this.aMap.addNavigateArrow(new NavigateArrowOptions().addAll(arrayList).width(this.mWidth * 0.6f));
            } else {
                this.naviArrow.setPoints(arrayList);
            }
            this.naviArrow.setZIndex(1.0f);
            this.naviArrow.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "RouteOverLay", "drawArrow(List<NaviLatLng> list) ");
        }
    }

    public List<NaviLatLng> getArrowPoints(int n2) {
        if (this.mAMapNaviPath == null) {
            return null;
        }
        try {
            NaviLatLng naviLatLng;
            int n3;
            NaviLatLng naviLatLng2;
            int n4;
            if (n2 >= this.mAMapNaviPath.getStepsCount()) {
                return null;
            }
            List<NaviLatLng> list = this.mAMapNaviPath.getCoordList();
            int n5 = list.size();
            List<AMapNaviStep> list2 = this.mAMapNaviPath.getSteps();
            AMapNaviStep aMapNaviStep = list2.get(n2);
            int n6 = aMapNaviStep.getEndIndex();
            NaviLatLng naviLatLng3 = list.get(n6);
            Vector<NaviLatLng> vector = new Vector<NaviLatLng>();
            NaviLatLng naviLatLng4 = naviLatLng3;
            int n7 = 0;
            int n8 = 50;
            for (n4 = n6 - 1; n4 >= 0; --n4) {
                naviLatLng2 = list.get(n4);
                n3 = db.a(naviLatLng4, naviLatLng2);
                if ((n7 += n3) >= n8) {
                    naviLatLng = db.a(naviLatLng4, naviLatLng2, n8 + n3 - n7);
                    vector.add(naviLatLng);
                    break;
                }
                naviLatLng4 = naviLatLng2;
                vector.add(naviLatLng2);
            }
            Collections.reverse(vector);
            vector.add(naviLatLng3);
            n7 = 0;
            naviLatLng4 = naviLatLng3;
            for (n4 = n6 + 1; n4 < n5; ++n4) {
                naviLatLng2 = list.get(n4);
                n3 = db.a(naviLatLng4, naviLatLng2);
                if ((n7 += n3) >= n8) {
                    naviLatLng = db.a(naviLatLng4, naviLatLng2, n8 + n3 - n7);
                    vector.add(naviLatLng);
                    break;
                }
                naviLatLng4 = naviLatLng2;
                vector.add(naviLatLng2);
            }
            if (vector.size() > 2) {
                return vector;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dw.b(exception, "RouteOverLay", "getArrowPoints(int roadIndex)");
        }
        return null;
    }

    public boolean isTrafficLine() {
        return this.isTrafficLine;
    }

    public void setTrafficLine(Boolean bl2) {
        try {
            if (this.mContext == null) {
                return;
            }
            this.isTrafficLine = bl2;
            List<AMapTrafficStatus> list = null;
            this.clearTrafficLineAndInvisibleOriginalLine();
            if (this.isTrafficLine) {
                if (this.mAMapNaviPath != null) {
                    list = AMapNavi.getInstance(this.mContext).getTrafficStatuses(0, this.mAMapNaviPath.getAllLength());
                }
                if (list == null) {
                    this.NoTrafficStatusDisplay();
                } else {
                    this.colorWayUpdate(list);
                }
            } else {
                this.NoTrafficStatusDisplay();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dw.b(throwable, "RouteOverLay", "setTrafficLine(Boolean enabled)");
        }
    }

    private void NoTrafficStatusDisplay() {
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setVisible(true);
        }
        if (this.mCustomPolylines.size() > 0) {
            for (int i2 = 0; i2 < this.mCustomPolylines.size(); ++i2) {
                if (this.mCustomPolylines.get(i2) == null) continue;
                this.mCustomPolylines.get(i2).setVisible(true);
            }
        }
    }

    private void addToMap(int[] nArray, int[] nArray2, BitmapDescriptor[] bitmapDescriptorArray) {
        try {
            Object object;
            int n2;
            Polyline polyline;
            Object object2;
            Object object3;
            List<NaviLatLng> list;
            if (this.aMap == null) {
                return;
            }
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
                this.mDefaultPolyline = null;
            }
            if (this.mWidth == 0.0f || this.mAMapNaviPath == null || this.normalRoute == null) {
                return;
            }
            if (this.naviArrow != null) {
                this.naviArrow.setVisible(false);
            }
            if ((list = this.mAMapNaviPath.getCoordList()) == null) {
                return;
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
            int n3 = list.size();
            this.mLatLngsOfPath = new ArrayList<LatLng>(n3);
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            int n4 = 0;
            int n5 = 0;
            n5 = nArray == null ? bitmapDescriptorArray.length : nArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                if (nArray2 != null && i2 < nArray2.length && nArray2[i2] <= 0) continue;
                arrayList.clear();
                while (n4 < list.size()) {
                    object3 = list.get(n4);
                    object2 = new LatLng(object3.getLatitude(), object3.getLongitude(), false);
                    this.mLatLngsOfPath.add((LatLng)object2);
                    arrayList.add((LatLng)object2);
                    if (nArray2 != null && i2 < nArray2.length && n4 == nArray2[i2]) break;
                    ++n4;
                }
                polyline = bitmapDescriptorArray == null || bitmapDescriptorArray.length == 0 ? this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).color(nArray[i2]).width(this.mWidth)) : this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).setCustomTexture(bitmapDescriptorArray[i2]).width(this.mWidth));
                polyline.setVisible(true);
                this.mCustomPolylines.add(polyline);
            }
            polyline = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).width(this.mWidth).setCustomTexture(this.arrowOnRoute));
            this.mCustomPolylines.add(polyline);
            LatLng latLng = null;
            object3 = null;
            object2 = null;
            if (this.mAMapNaviPath.getStartPoint() != null && this.mAMapNaviPath.getEndPoint() != null) {
                latLng = new LatLng(this.mAMapNaviPath.getStartPoint().getLatitude(), this.mAMapNaviPath.getStartPoint().getLongitude());
                object3 = new LatLng(this.mAMapNaviPath.getEndPoint().getLatitude(), this.mAMapNaviPath.getEndPoint().getLongitude());
                object2 = this.mAMapNaviPath.getWayPoint();
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            if (this.wayMarkers != null && this.wayMarkers.size() > 0) {
                for (n2 = 0; n2 < this.wayMarkers.size(); ++n2) {
                    object = this.wayMarkers.get(n2);
                    if (object == null) continue;
                    ((Marker)object).remove();
                    object = null;
                }
            }
            if (this.startBitmap == null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837638))));
            } else if (this.startBitmapDescriptor != null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(this.startBitmapDescriptor));
            }
            if (object2 != null && object2.size() > 0) {
                n2 = object2.size();
                if (this.wayMarkers == null) {
                    this.wayMarkers = new ArrayList<Marker>(n2);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    NaviLatLng naviLatLng = (NaviLatLng)object.next();
                    LatLng latLng2 = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude());
                    Marker marker = null;
                    if (this.wayBitmap == null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position(latLng2).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837645))));
                    } else if (this.wayPointBitmapDescriptor != null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position(latLng2).icon(this.wayPointBitmapDescriptor));
                    }
                    this.wayMarkers.add(marker);
                }
            }
            if (this.endBitmap == null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object3).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)dc.a(), (int)2130837520))));
            } else if (this.endBitmapDescriptor != null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object3).icon(this.endBitmapDescriptor));
            }
            if (this.isTrafficLine) {
                this.setTrafficLine(this.isTrafficLine);
            }
        }
        catch (Throwable throwable) {
            db.a(throwable);
            dw.b(throwable, "RouteOverLay", "addToMap(int[] color, int[] index, BitmapDescriptor[] resourceArray)");
        }
    }

    public void addToMap(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.addToMap(nArray, nArray2, null);
    }

    public void addToMap(BitmapDescriptor[] bitmapDescriptorArray, int[] nArray) {
        if (bitmapDescriptorArray == null || bitmapDescriptorArray.length == 0) {
            return;
        }
        this.addToMap(null, nArray, bitmapDescriptorArray);
    }

    public void setTransparency(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setTransparency(f2);
        }
        for (Polyline polyline : this.mTrafficColorfulPolylines) {
            polyline.setTransparency(f2);
        }
    }

    public boolean isContains(Polyline polyline) {
        if (polyline == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mTrafficColorfulPolylines != null) {
            for (int i2 = 0; i2 < this.mTrafficColorfulPolylines.size(); ++i2) {
                arrayList.add(this.mTrafficColorfulPolylines.get(i2).getId());
            }
        }
        arrayList.add(this.mDefaultPolyline.getId());
        return arrayList.contains(polyline.getId());
    }
}

