/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.autonavi.amap.mapcore.BaseMapLoader;
import com.autonavi.amap.mapcore.ConnectionManager;
import com.autonavi.amap.mapcore.IBaseMapCallback;
import com.autonavi.amap.mapcore.IMapCallback;
import com.autonavi.amap.mapcore.IndoorMapLoader;
import com.autonavi.amap.mapcore.MapCore;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.NormalMapLoader;
import com.autonavi.amap.mapcore.TextTextureGenerator;
import com.autonavi.amap.mapcore.VMapDataCache;
import com.autonavi.amap.mapcore.VTMCDataCache;
import com.autonavi.amap.mapcore.d;
import com.autonavi.amap.mapcore.e;
import com.autonavi.amap.mapcore.f;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMapCallImplement
implements IBaseMapCallback,
IMapCallback {
    private ArrayList<MapSourceGridData> roadReqMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> bldReqMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> regionReqMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> poiReqMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> versionMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> indoorMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> vectmcReqMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> stiReqMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> curRoadMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> curBldMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> curRegionMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> curPoiMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> curVectmcMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> curStiMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> curScreenGirds = new ArrayList();
    private ArrayList<MapSourceGridData> curIndoorMapGirds = new ArrayList();
    ConnectionManager connectionManager = null;
    d tileProcessCtrl = null;
    TextTextureGenerator textTextureGenerator = null;
    Object mapGridFillLock = new Object();

    @Override
    public void OnMapDataRequired(MapCore mapCore, int n2, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<MapSourceGridData> arrayList = null;
        arrayList = this.getReqGridList(n2);
        if (arrayList != null) {
            arrayList.clear();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(new MapSourceGridData(stringArray[i2], n2));
            }
            if (n2 != 5) {
                this.proccessRequiredData(mapCore, arrayList, n2);
            }
        }
    }

    @Override
    public void OnMapProcessEvent(MapCore mapCore) {
    }

    public ArrayList<MapSourceGridData> getReqGridList(int n2) {
        if (n2 == 0) {
            return this.roadReqMapGrids;
        }
        if (n2 == 1) {
            return this.bldReqMapGrids;
        }
        if (n2 == 7) {
            return this.regionReqMapGrids;
        }
        if (n2 == 8) {
            return this.poiReqMapGrids;
        }
        if (n2 == 4) {
            return this.vectmcReqMapGirds;
        }
        if (n2 == 5) {
            return this.curScreenGirds;
        }
        if (n2 == 3) {
            return this.stiReqMapGirds;
        }
        if (n2 == 9) {
            return this.versionMapGrids;
        }
        if (n2 == 10) {
            return this.indoorMapGrids;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnMapSurfaceRenderer(GL10 gL10, MapCore mapCore, int n2) {
        if (n2 == 11) {
            Object object = this.mapGridFillLock;
            synchronized (object) {
                mapCore.fillCurGridListWithDataType(this.curPoiMapGrids, 8);
                mapCore.fillCurGridListWithDataType(this.curRoadMapGrids, 0);
                mapCore.fillCurGridListWithDataType(this.curRegionMapGrids, 7);
                mapCore.fillCurGridListWithDataType(this.curBldMapGrids, 1);
                mapCore.fillCurGridListWithDataType(this.curVectmcMapGirds, 4);
                mapCore.fillCurGridListWithDataType(this.curStiMapGirds, 3);
                mapCore.fillCurGridListWithDataType(this.curIndoorMapGirds, 10);
            }
        }
    }

    public ArrayList<MapSourceGridData> getCurGridList(int n2) {
        if (n2 == 0) {
            return this.curRoadMapGrids;
        }
        if (n2 == 1) {
            return this.curBldMapGrids;
        }
        if (n2 == 7) {
            return this.curRegionMapGrids;
        }
        if (n2 == 8) {
            return this.curPoiMapGrids;
        }
        if (n2 == 4) {
            return this.curVectmcMapGirds;
        }
        if (n2 == 5) {
            return this.curScreenGirds;
        }
        if (n2 == 10) {
            return this.curIndoorMapGirds;
        }
        if (n2 == 3) {
            return this.curStiMapGirds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGridsInScreen(ArrayList<MapSourceGridData> arrayList, int n2) {
        try {
            if (arrayList.size() == 0) {
                return false;
            }
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mapGridFillLock;
            synchronized (object) {
                ArrayList<MapSourceGridData> arrayList2 = this.getCurGridList(n2);
                if (arrayList2 == null) {
                    return true;
                }
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (!this.isGridInList(arrayList.get(i2).getGridName(), arrayList2)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGridInScreen(int n2, String string) {
        try {
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mapGridFillLock;
            synchronized (object) {
                ArrayList<MapSourceGridData> arrayList = this.getCurGridList(n2);
                return this.isGridInList(string, arrayList);
                {
                }
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    private boolean isGridInList(String string, ArrayList<MapSourceGridData> arrayList) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (!arrayList.get(i2).getGridName().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndoorGridsInScreen(ArrayList<MapSourceGridData> arrayList, int n2) {
        try {
            if (arrayList.size() == 0) {
                return false;
            }
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mapGridFillLock;
            synchronized (object) {
                ArrayList<MapSourceGridData> arrayList2 = this.getCurGridList(n2);
                if (arrayList2 == null) {
                    return true;
                }
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (!this.isIndoorGridInList(arrayList.get(i2).getKeyGridName(), arrayList2)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndoorGridInScreen(int n2, String string, short s2) {
        try {
            if (!this.isMapEngineValid()) {
                return false;
            }
            Object object = this.mapGridFillLock;
            synchronized (object) {
                ArrayList<MapSourceGridData> arrayList = this.getCurGridList(n2);
                String string2 = n2 + "-" + string + "-" + s2;
                return this.isIndoorGridInList(string2, arrayList);
                {
                }
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    private boolean isIndoorGridInList(String string, ArrayList<MapSourceGridData> arrayList) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (!arrayList.get(i2).getKeyGridName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void proccessRequiredData(MapCore mapCore, ArrayList<MapSourceGridData> arrayList, int n2) {
        Object object;
        ArrayList<MapSourceGridData> arrayList2 = new ArrayList<MapSourceGridData>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object2;
            MapSourceGridData mapSourceGridData = arrayList.get(i2);
            if (this.tileProcessCtrl != null && this.tileProcessCtrl.b(mapSourceGridData.getKeyGridName())) continue;
            if (n2 == 4) {
                object = VTMCDataCache.getInstance();
                object2 = ((VTMCDataCache)object).getData(mapSourceGridData.getGridName(), true);
                f f2 = ((VTMCDataCache)object).getData(mapSourceGridData.getGridName(), false);
                if (object2 != null) {
                    mapSourceGridData.obj = ((f)object2).d;
                }
                if (f2 != null && f2.a != null && f2.a.length > 0) {
                    mapCore.putMapData(f2.a, 0, f2.a.length, n2, f2.c);
                    continue;
                }
                arrayList2.add(mapSourceGridData);
                continue;
            }
            try {
                object = mapSourceGridData.gridName;
                if (n2 == 10) {
                    object = mapSourceGridData.gridName + "-" + mapSourceGridData.mIndoorIndex;
                }
                if ((object2 = VMapDataCache.getInstance().getRecoder((String)object, n2)) == null || ((e)object2).a == null || ((e)object2).a.length() > 0) {
                    // empty if block
                }
                arrayList2.add(mapSourceGridData);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList2.size() > 0) {
            BaseMapLoader baseMapLoader = null;
            if (n2 == 10) {
                baseMapLoader = new IndoorMapLoader(mapCore, this, n2);
            } else if (n2 != 11) {
                baseMapLoader = new NormalMapLoader(mapCore, this, n2);
            }
            for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                object = (MapSourceGridData)arrayList2.get(i3);
                this.tileProcessCtrl.c(((MapSourceGridData)object).getKeyGridName());
                baseMapLoader.addReuqestTiles((MapSourceGridData)object);
            }
            if (this.connectionManager != null) {
                this.connectionManager.insertConntionTask(baseMapLoader);
            }
        }
    }

    public void OnMapSurfaceCreate(MapCore mapCore) {
    }

    public synchronized void onPause() {
        try {
            if (this.connectionManager != null) {
                this.connectionManager.threadFlag = false;
                if (this.connectionManager.isAlive()) {
                    this.connectionManager.interrupt();
                    this.connectionManager.shutDown();
                    this.connectionManager = null;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void onResume(MapCore mapCore) {
        try {
            this.connectionManager = new ConnectionManager(mapCore);
            this.tileProcessCtrl = new d();
            this.connectionManager.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void OnMapDestory(MapCore mapCore) {
        try {
            this.destoryMap(mapCore);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public byte[] OnMapCharsWidthsRequired(MapCore mapCore, int[] nArray, int n2, int n3) {
        if (this.textTextureGenerator == null) {
            this.textTextureGenerator = new TextTextureGenerator();
        }
        return this.textTextureGenerator.getCharsWidths(nArray);
    }

    @Override
    public void OnMapLabelsRequired(MapCore mapCore, int[] nArray, int n2) {
        if (nArray == null || n2 <= 0) {
            return;
        }
        int[] nArray2 = nArray;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray2[i2];
            this.textTextureGenerator = new TextTextureGenerator();
            byte[] byArray = this.textTextureGenerator.getTextPixelBuffer(n3);
            if (byArray != null) {
                mapCore.putCharbitmap(n3, byArray);
            }
            byArray = null;
        }
    }

    public synchronized void newMap(MapCore mapCore) {
        this.connectionManager = new ConnectionManager(mapCore);
        this.tileProcessCtrl = new d();
        this.connectionManager.start();
    }

    public synchronized void destoryMap(MapCore mapCore) {
        if (this.connectionManager != null) {
            this.connectionManager.threadFlag = false;
            if (this.connectionManager.isAlive()) {
                try {
                    this.connectionManager.interrupt();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.connectionManager.shutDown();
                    this.connectionManager = null;
                }
            }
        }
        if (this.tileProcessCtrl != null) {
            this.tileProcessCtrl.a();
        }
    }
}

