/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import com.amap.api.maps.MapsInitializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileUtil {
    private static final String TAG = "FileUtil";

    public static void copy(Context context, String string, File file) throws Exception {
        file.delete();
        InputStream inputStream = context.getAssets().open(string);
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        inputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FileUtil.deleteFile(fileArray[i2]);
            }
        }
        file.delete();
    }

    public static String getMapBaseStorage(Context context) {
        File file;
        int n2 = Build.VERSION.SDK_INT;
        String string = "map_base_path";
        if (n2 > 18) {
            string = "map_base_path_v44";
        }
        String string2 = "";
        SharedPreferences sharedPreferences = context.getSharedPreferences("base_path", 0);
        string2 = MapsInitializer.sdcardDir != null && MapsInitializer.sdcardDir.trim().length() > 0 ? MapsInitializer.sdcardDir : sharedPreferences.getString(string, "");
        if (string2 != null && string2.length() > 2) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                if (file.canWrite()) {
                    return string2;
                }
                string2 = context.getCacheDir().toString();
                if (string2 != null && string2.length() > 2 && (file = new File(string2)).isDirectory()) {
                    return string2;
                }
            }
        }
        if ((string2 = FileUtil.getExternalStroragePath(context)) != null && string2.length() > 2) {
            file = new File(string2 = string2 + File.separator + "amap");
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(string, string2);
                editor.commit();
                FileUtil.createNoMediaFileIfNotExist(string2);
                return string2;
            }
        }
        if ((string2 = context.getCacheDir().toString()) != null && string2.length() > 2) {
            file = new File(string2 = string2 + File.separator + "amap");
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                return string2;
            }
        }
        return string2;
    }

    public static String getExternalStroragePath(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 12) {
            try {
                StorageManager storageManager = (StorageManager)context.getSystemService("storage");
                Method method = StorageManager.class.getMethod("getVolumeList", new Class[0]);
                Method method2 = StorageManager.class.getMethod("getVolumeState", String.class);
                Object[] objectArray = (Object[])method.invoke((Object)storageManager, new Object[0]);
                String string = null;
                String string2 = null;
                Boolean bl2 = false;
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = null;
                for (Object object : objectArray) {
                    Method method3 = object.getClass().getMethod("getPath", new Class[0]);
                    Method method4 = object.getClass().getMethod("isRemovable", new Class[0]);
                    string2 = (String)method3.invoke(object, new Object[0]);
                    string = (String)method2.invoke((Object)storageManager, method3.invoke(object, new Object[0]));
                    bl2 = (Boolean)method4.invoke(object, new Object[0]);
                    if (string2.toLowerCase().contains("private")) continue;
                    if (bl2.booleanValue()) {
                        string3 = string2;
                        string5 = string;
                        if (null == string3 || null == string5 || !string5.equals("mounted")) continue;
                        if (n2 <= 18) {
                            string7 = string3;
                            break;
                        }
                        try {
                            File[] fileArray = context.getExternalFilesDirs(null);
                            if (fileArray == null) break;
                            if (fileArray.length > 1) {
                                string7 = fileArray[1].getAbsolutePath();
                                break;
                            }
                            string7 = string2;
                        }
                        catch (Exception exception) {
                            string7 = string3;
                        }
                        break;
                    }
                    string4 = string2;
                    string6 = string;
                }
                if (n2 <= 18) {
                    if (null == string7 && null != string4 && null != string6 && string6.equals("mounted")) {
                        string7 = string4;
                    }
                    return string7;
                }
                if (null != string4 && null != string6 && string6.equals("mounted")) {
                    string7 = string4;
                }
                return string7;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File file = null;
        boolean bl3 = Environment.getExternalStorageState().equals("mounted");
        if (bl3) {
            file = Environment.getExternalStorageDirectory();
            return file.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDatasToFile(String string, byte[] byArray) {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (byArray == null || byArray.length == 0) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            writeLock.unlock();
        }
    }

    public static byte[] readFileContents(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            fileInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void createNoMediaFileIfNotExist(String string) {
    }
}

