/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.text.TextUtils;
import com.amap.api.col.df;
import com.amap.api.col.di;
import com.amap.api.col.dq;
import com.amap.api.col.j;
import com.autonavi.amap.mapcore.BaseMapCallImplement;
import com.autonavi.amap.mapcore.BaseMapLoader;
import com.autonavi.amap.mapcore.Convert;
import com.autonavi.amap.mapcore.MapCore;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.Md5Utility;
import com.autonavi.amap.mapcore.VMapDataCache;

public class IndoorMapLoader
extends BaseMapLoader {
    private String mIndoorChannel = "amap7";
    private static final String IndoorSignKey = "@1071a2a4e3gte2Uc32cY3a98Tf33H1c4Gc23f";

    public IndoorMapLoader(MapCore mapCore, BaseMapCallImplement baseMapCallImplement, int n2) {
        this.datasource = n2;
        this.mGLMapEngine = mapCore;
        this.mMapCallback = baseMapCallImplement;
        this.createtime = System.currentTimeMillis();
    }

    public static int getInt2(byte[] byArray, int n2) {
        int n3 = byArray[0 + n2] & 0xFF;
        int n4 = byArray[1 + n2] & 0xFF;
        int n5 = byArray[2 + n2] & 0xFF;
        int n6 = byArray[3 + n2] & 0xFF;
        int n7 = (n3 << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
        return n7;
    }

    public static short getShort2(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 0] & 0xFF;
        int n4 = byArray[n2 + 1] & 0xFF;
        short s2 = (short)((n3 << 8) + (n4 << 0));
        return s2;
    }

    private String getIndoorMD5Params(String string) {
        return Md5Utility.getStringMD5(this.mIndoorChannel + string + IndoorSignKey).toUpperCase();
    }

    private String getIndoorRequestParams() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = ";";
        for (int i2 = 0; i2 < this.mapTiles.size(); ++i2) {
            String string5 = ((MapSourceGridData)this.mapTiles.get(i2)).getGridName();
            int n2 = ((MapSourceGridData)this.mapTiles.get((int)i2)).mIndoorIndex;
            int n3 = ((MapSourceGridData)this.mapTiles.get((int)i2)).mIndoorVersion;
            if (string5 == null || string5.length() == 0 || this.containllegal(string5) || !this.isAssic(string5)) continue;
            string = string == null ? string5 + string4 : string + string5 + string4;
            string2 = string2 == null ? n2 + string4 : string2 + n2 + string4;
            string3 = string3 == null ? n3 + string4 : string3 + n3 + string4;
        }
        if (!TextUtils.isEmpty(string) && (string.endsWith(string4) || string.endsWith(" "))) {
            string = string.substring(0, string.length() - 1);
        }
        if (!TextUtils.isEmpty(string2) && (string2.endsWith(string4) || string2.endsWith(" "))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!TextUtils.isEmpty(string3) && (string3.endsWith(string4) || string3.endsWith(" "))) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("poiid=").append(string).append("&").append("floor=").append(string2).append("&").append("version=").append(string3).append("&").append("diver=").append(j.e).append("&").append("servicetype=unify").append("&").append("zoomlevel=").append((int)this.mGLMapEngine.getMapstate().getMapZoomer()).append("&").append("key=").append(df.f(this.mMapCallback.getContext()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.assScodeToParma(stringBuffer);
    }

    private String assScodeToParma(StringBuffer stringBuffer) {
        String string = dq.d(stringBuffer.toString());
        String string2 = di.a();
        stringBuffer.append("&ts=" + string2 + "&");
        stringBuffer.append("scode=" + di.a(this.mMapCallback.getContext(), string2, string));
        return stringBuffer.toString();
    }

    protected String getGridParma() {
        return this.getIndoorRequestParams();
    }

    protected String getMapAddress() {
        return "http://restapi.amap.com/v3/indoor/indoormaps";
    }

    protected String getMapSvrPath() {
        String string = null;
        switch (this.datasource) {
            case 10: {
                string = "?";
                break;
            }
        }
        return string;
    }

    public boolean isRequestValid() {
        return this.mMapCallback.isIndoorGridsInScreen(this.mapTiles, this.datasource);
    }

    private void processReceivedIndoorData() {
        if (this.nextImgDataLength == 0) {
            if (this.recievedDataSize >= 6) {
                this.nextImgDataLength = IndoorMapLoader.getInt2(this.recievedDataBuffer, 0);
                this.processReceivedIndoorData();
            }
        } else if (this.recievedDataSize >= this.nextImgDataLength) {
            this.processReceivedTileDataV4(this.recievedDataBuffer, 0, this.nextImgDataLength);
            Convert.moveArray(this.recievedDataBuffer, this.nextImgDataLength, this.recievedDataBuffer, 0, this.recievedDataSize - this.nextImgDataLength);
            this.recievedDataSize -= this.nextImgDataLength;
            this.nextImgDataLength = 0;
            this.processReceivedIndoorData();
        }
    }

    protected void processReceivedTileDataV4(byte[] byArray, int n2, int n3) {
        byte by2;
        int n4 = n2;
        n4 = n2 += 4;
        if ((by2 = byArray[n2++]) > 10) {
            return;
        }
        String string = "";
        short s2 = 0;
        if (by2 > 0 && n2 + by2 - 1 < n3) {
            string = new String(byArray, n2, (int)by2);
        }
        n2 += by2;
        if (!this.mGLMapEngine.isMapEngineValid()) {
            return;
        }
        if (n3 <= n4) {
            return;
        }
        boolean bl2 = false;
        s2 = IndoorMapLoader.getShort2(byArray, n2);
        boolean bl3 = bl2 = !this.mMapCallback.isIndoorGridInScreen(this.datasource, string, s2);
        if (this.mGLMapEngine.putMapData(byArray, n4, n3 - n4, this.datasource, 0)) {
            string = string + "-" + s2;
            VMapDataCache.getInstance().putRecoder(null, string, this.datasource);
        }
        if (bl2) {
            this.doCancel();
        }
    }

    protected void processRecivedVersionOrScenicWidgetData() {
        if (this.datasource == 9) {
            this.processRecivedVersionData(this.recievedDataBuffer, 0, this.recievedDataSize);
        }
    }

    protected boolean processReceivedDataHeader(int n2) {
        if (this.recievedDataSize > 5) {
            int n3 = 6;
            Convert.moveArray(this.recievedDataBuffer, n3, this.recievedDataBuffer, 0, n2 - 6);
            this.recievedDataSize -= n3;
            this.nextImgDataLength = 0;
            this.recievedHeader = true;
            this.processReceivedIndoorData();
            return true;
        }
        return false;
    }

    protected boolean isNeedProcessReturn() {
        return this.datasource == 9;
    }

    protected void processRecivedDataByType() {
        this.processReceivedIndoorData();
    }
}

