/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.text.TextUtils;
import com.autonavi.amap.mapcore.Convert;
import com.autonavi.amap.mapcore.IMapCallback;
import com.autonavi.amap.mapcore.MapProjection;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.MapTilsCacheAndResManager;
import com.autonavi.amap.mapcore.SelectedMapPoi;
import com.autonavi.amap.mapcore.TextTextureGenerator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCore {
    public static final int TEXTURE_ICON = 0;
    public static final int TEXTURE_BACKGROUND = 1;
    public static final int TEXTURE_ROADARROW = 2;
    public static final int TEXTURE_ROADROUND = 3;
    public static final int TEXTURE_TMC_RED = 4;
    public static final int TEXTURE_TMC_YELLOW = 5;
    public static final int TEXTURE_TMC_GREEN = 6;
    public static final int TEXTURE_TMC_BLACK = 7;
    public static final int TEXTURE_RAILWAY = 8;
    public static final int AM_DATA_ROADMAP = 0;
    public static final int AM_DATA_GEO_BUILDING = 1;
    public static final int AM_DATA_BMP_BASEMAP = 2;
    public static final int AM_DATA_SATELLITE = 3;
    public static final int AM_DATA_VEC_TMC = 4;
    public static final int AM_DATA_SCREEN = 5;
    public static final int AM_DATA_MODEL = 6;
    public static final int AM_DATA_STANDARD = 7;
    public static final int AM_DATA_POI = 8;
    public static final int AM_DATA_VERSION = 9;
    public static final int AM_DATA_INDOOR = 10;
    public static final int AM_DATA_GUIDE = 11;
    public static final int AM_DATA_SCENIC_WIDGET = 101;
    public static final int MAPRENDER_ENTER = 0;
    public static final int MAPRENDER_BASEMAPBEGIN = 1;
    public static final int MAPRENDER_BUILDINGBEGIN = 2;
    public static final int MAPRENDER_LABELSBEGIN = 3;
    public static final int MAPRENDER_LABELSEND = 4;
    public static final int MAPRENDER_RENDEROVER = 5;
    public static final int MAPRENDER_NOMORENEEDRENDER = 6;
    public static final int MAPRENDER_ORTHOPROJECTION = 7;
    public static final int MAPRENDER_GRID_CAN_FILL = 11;
    public static final int MAPRENDER_CAN_STOP_AND_FULLSCREEN_RENDEROVER = 999;
    Context mContext;
    private IMapCallback mMapcallback = null;
    private TextTextureGenerator textTextureGenerator = null;
    long native_instance = 0L;
    GL10 mGL = null;
    byte[] tmp_3072bytes_data;

    public MapCore(Context context) {
        this.mContext = context;
        MapTilsCacheAndResManager.getInstance(context).checkDir();
    }

    public void newMap() {
        MapTilsCacheAndResManager.getInstance(this.mContext).checkDir();
        String string = MapTilsCacheAndResManager.getInstance(this.mContext).getBaseMapPath();
        this.textTextureGenerator = new TextTextureGenerator();
        this.tmp_3072bytes_data = ByteBuffer.allocate(3072).array();
        String string2 = this.textTextureGenerator.getFontVersion();
        this.native_instance = MapCore.nativeNewInstance(string, string2);
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setGL(GL10 gL10) {
        this.mGL = gL10;
    }

    public void setMapCallback(IMapCallback iMapCallback) {
        this.mMapcallback = iMapCallback;
    }

    public boolean isMapEngineValid() {
        return this.native_instance != 0L;
    }

    public void surfaceCreate(GL10 gL10) {
        if (this.native_instance != 0L) {
            MapCore.nativeSurfaceCreate(this.native_instance, this);
        }
    }

    public void surfaceChange(GL10 gL10, int n2, int n3) {
        if (this.native_instance != 0L) {
            MapCore.nativeSurfaceChange(this.native_instance, this, n2, n3);
        }
    }

    public void drawFrame(GL10 gL10) {
        if (this.native_instance != 0L) {
            MapCore.nativeSurfaceRenderMap(this.native_instance, this);
        }
    }

    public void setStyleData(byte[] byArray, int n2, int n3) {
        if (this.native_instance != 0L && byArray != null && byArray.length > 0) {
            MapCore.nativeSetStyleData(this.native_instance, byArray, n2, n3);
        }
    }

    public void setInternaltexture(byte[] byArray, int n2) {
        if (this.native_instance != 0L) {
            MapCore.nativeSetInternaltexture(this.native_instance, byArray, n2);
        }
    }

    public long getInstanceHandle() {
        return this.native_instance;
    }

    public MapProjection getMapstate() {
        if (this.native_instance != 0L) {
            long l2 = MapCore.nativeGetMapstate(this.native_instance);
            return new MapProjection(l2);
        }
        return null;
    }

    public void setMapstate(MapProjection mapProjection) {
        if (this.native_instance != 0L) {
            MapCore.nativeSetMapstate(this.native_instance, mapProjection.getInstanceHandle());
        }
    }

    public void setParameter(int n2, int n3, int n4, int n5, int n6) {
        if (this.native_instance != 0L) {
            MapCore.nativeSetparameter(this.native_instance, n2, n3, n4, n5, n6);
        }
    }

    public void setIndoorBuildingToBeActive(String string, int n2, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        MapCore.nativeSetIndoorBuildingToBeActive(this.native_instance, string, n2, string2);
    }

    public boolean putMapData(byte[] byArray, int n2, int n3, int n4, int n5) {
        boolean bl2 = false;
        if (this.native_instance != 0L) {
            if (byArray.length == n3 && n2 == 0) {
                bl2 = MapCore.nativePutMapdata(this.native_instance, n4, byArray) > 0;
            } else {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                boolean bl3 = bl2 = MapCore.nativePutMapdata(this.native_instance, n4, byArray2) > 0;
            }
            if (this.mMapcallback != null) {
                this.mMapcallback.requestRender();
            }
        }
        return bl2;
    }

    public int getLabelBuffer(int n2, int n3, int n4, byte[] byArray) {
        if (this.native_instance != 0L) {
            return MapCore.nativeSelectMapPois(this.native_instance, n2, n3, n4, byArray);
        }
        return 0;
    }

    public SelectedMapPoi GetSelectedMapPoi(int n2, int n3, int n4) {
        if (this.native_instance != 0L) {
            byte[] byArray = new byte[1024];
            int n5 = MapCore.nativeGetSelectedMapPois(this.native_instance, n2, n3, n4, byArray);
            if (n5 == 0) {
                return null;
            }
            if (n5 > 0) {
                int n6;
                SelectedMapPoi selectedMapPoi = new SelectedMapPoi();
                int n7 = 0;
                selectedMapPoi.winx = Convert.getInt(byArray, n7);
                selectedMapPoi.winy = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.mapx = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.mapy = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.iconXmin = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.iconXmax = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.iconYmin = Convert.getInt(byArray, n7 += 4);
                selectedMapPoi.iconYmax = Convert.getInt(byArray, n7 += 4);
                n7 += 4;
                int n8 = byArray[n7++];
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < n8; ++i2) {
                    n6 = Convert.getShort(byArray, n7);
                    n7 += 2;
                    stringBuffer.append((char)n6);
                }
                selectedMapPoi.name = stringBuffer.toString();
                n8 = byArray[n7++];
                StringBuffer stringBuffer2 = new StringBuffer();
                for (n6 = 0; n6 < n8; ++n6) {
                    char c2 = (char)Convert.getShort(byArray, n7);
                    n7 += 2;
                    if (c2 == '\u0000') break;
                    stringBuffer2.append(c2);
                }
                selectedMapPoi.poiid = stringBuffer2.toString();
                return selectedMapPoi;
            }
        }
        return null;
    }

    public void putCharbitmap(int n2, byte[] byArray) {
        if (this.native_instance != 0L) {
            MapCore.nativePutCharbitmap(this.native_instance, n2, byArray);
        }
    }

    public boolean canStopRenderMap() {
        if (this.native_instance != 0L) {
            return MapCore.nativeCanStopRenderMap(this.native_instance);
        }
        return false;
    }

    private void OnMapSurfaceCreate() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSurfaceCreate(this.mGL, this);
        }
    }

    private void OnMapSufaceChanged(int n2, int n3) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSufaceChanged(this.mGL, this, n2, n3);
        }
    }

    private void OnMapSurfaceRenderer(int n2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSurfaceRenderer(this.mGL, this, n2);
        }
    }

    private void OnMapProcessEvent() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapProcessEvent(this);
        }
    }

    private void OnMapDestory() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapDestory(this.mGL, this);
        }
    }

    public void OnMapDataRequired(int n2, String[] stringArray) {
        if (this.mMapcallback != null) {
            try {
                this.mMapcallback.OnMapDataRequired(this, n2, stringArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void OnMapLabelsRequired(int[] nArray, int n2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapLabelsRequired(this, nArray, n2);
        }
    }

    private byte[] OnMapCharsWidthsRequired(int[] nArray, int n2, int n3) {
        if (this.mMapcallback != null) {
            return this.mMapcallback.OnMapCharsWidthsRequired(this, nArray, n2, n3);
        }
        return null;
    }

    private void OnMapReferencechanged(String string, String string2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapReferencechanged(this, string, string2);
        }
    }

    public void onIndoorBuildingActivity(byte[] byArray) {
        if (this.mMapcallback != null) {
            try {
                this.mMapcallback.onIndoorBuildingActivity(this, byArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void onIndoorDataRequired(int n2, String[] stringArray, int[] nArray, int[] nArray2) {
        if (this.mMapcallback != null) {
            try {
                this.mMapcallback.onIndoorDataRequired(this, n2, stringArray, nArray, nArray2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void destroy() throws Throwable {
        if (this.native_instance != 0L) {
            MapCore.nativeDestroy(this.native_instance, this);
            this.native_instance = 0L;
            this.textTextureGenerator = null;
            this.tmp_3072bytes_data = null;
        }
    }

    public void fillCurGridListWithDataType(ArrayList<MapSourceGridData> arrayList, int n2) {
        if (this.native_instance != 0L) {
            MapCore.nativeGetScreenGrids(this.native_instance, this.tmp_3072bytes_data, n2);
            int n3 = 0;
            int n4 = this.tmp_3072bytes_data[n3++];
            if (n4 <= 0 || n4 > 100 || arrayList == null) {
                return;
            }
            arrayList.clear();
            ArrayList<MapSourceGridData> arrayList2 = arrayList;
            for (int i2 = 0; i2 < n4 && n3 < 3072; ++i2) {
                byte by2;
                if ((by2 = this.tmp_3072bytes_data[n3++]) <= 0 || by2 > 20 || n3 + by2 > 3072) continue;
                String string = new String(this.tmp_3072bytes_data, n3, (int)by2);
                n3 += by2;
                if (n2 == 10) {
                    short s2 = Convert.getShort(this.tmp_3072bytes_data, n3);
                    n3 += 2;
                    ++n3;
                    arrayList2.add(new MapSourceGridData(string, n2, s2, 0));
                    continue;
                }
                ++n3;
                arrayList2.add(new MapSourceGridData(string, n2));
            }
        }
    }

    private static native long nativeNewInstance(String var0, String var1);

    private static native void nativeDestroy(long var0, MapCore var2);

    private static native void nativeSetStyleData(long var0, byte[] var2, int var3, int var4);

    private static native void nativeSetInternaltexture(long var0, byte[] var2, int var3);

    private static native void nativeSurfaceCreate(long var0, MapCore var2);

    private static native void nativeSurfaceChange(long var0, MapCore var2, int var3, int var4);

    private static native void nativeSurfaceRenderMap(long var0, MapCore var2);

    private static native void nativeSetMapstate(long var0, long var2);

    private static native long nativeGetMapstate(long var0);

    private static native int nativeGetSelectedMapPois(long var0, int var2, int var3, int var4, byte[] var5);

    private static native void nativeSetparameter(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int nativePutMapdata(long var0, int var2, byte[] var3);

    private static native void nativePutCharbitmap(long var0, int var2, byte[] var3);

    private static native void nativeGetScreenGrids(long var0, byte[] var2, int var3);

    private static native void nativeChangeMapEnv(long var0, String var2);

    private static native void nativeSetInternalTexture(long var0, byte[] var2, int var3);

    private static native void nativeSetCityBound(long var0, byte[] var2);

    private static native boolean nativeCanStopRenderMap(long var0);

    private static native int nativePutMapdata(long var0, int var2, byte[] var3, int var4);

    private static native void nativeSetParmater(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int nativeGetMapStateInstance(long var0);

    private static native int nativeSelectMapPois(long var0, int var2, int var3, int var4, byte[] var5);

    private static native void nativeAddPoiFilter(long var0, int var2, int var3, int var4, float var5, float var6, String var7);

    private static native void nativeRemovePoiFilter(long var0, String var2);

    private static native void nativeClearPoiFilter(long var0);

    private static native void nativeSetIndoorBuildingToBeActive(long var0, String var2, int var3, String var4);

    static {
        try {
            System.loadLibrary("gdinamapv4sdk752");
            System.loadLibrary("gdinamapv4sdk752ex");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

