/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.MapCore;

public class MapProjection {
    long native_instance = 0L;
    private boolean m_bNewInstance = false;

    public MapProjection(MapCore mapCore) {
        this.native_instance = MapProjection.nativeNewInstance(mapCore.getInstanceHandle());
        this.m_bNewInstance = true;
    }

    public MapProjection(long l2) {
        this.native_instance = l2;
        this.m_bNewInstance = false;
    }

    public void recycle() {
        if (this.m_bNewInstance) {
            MapProjection.nativeDestroy(this.native_instance);
        }
    }

    long getInstanceHandle() {
        return this.native_instance;
    }

    public void getBound(IPoint iPoint) {
        MapProjection.nativeGetBound(this.native_instance, iPoint);
    }

    public void setGeoCenter(int n2, int n3) {
        MapProjection.nativeSetGeoCenter(this.native_instance, n2, n3);
    }

    public void getGeoCenter(IPoint iPoint) {
        MapProjection.nativeGetGeoCenter(this.native_instance, iPoint);
    }

    public void setMapCenter(float f2, float f3) {
        MapProjection.nativeSetMapCenter(this.native_instance, f2, f3);
    }

    public void getMapCenter(FPoint fPoint) {
        MapProjection.nativeGetMapCenter(this.native_instance, fPoint);
    }

    public void setMapZoomer(float f2) {
        MapProjection.nativeSetMapZoomer(this.native_instance, f2);
    }

    public float getMapZoomer() {
        return MapProjection.nativeGetMapZoomer(this.native_instance);
    }

    public void setMapAngle(float f2) {
        MapProjection.nativeSetMapAngle(this.native_instance, f2);
    }

    public float getMapAngle() {
        return MapProjection.nativeGetMapAngle(this.native_instance);
    }

    public void setCameraHeaderAngle(float f2) {
        MapProjection.nativeSetCameraHeaderAngle(this.native_instance, f2);
    }

    public float getCameraHeaderAngle() {
        return MapProjection.nativeGetCameraHeaderAngle(this.native_instance);
    }

    public void geo2Map(int n2, int n3, FPoint fPoint) {
        MapProjection.nativeGeo2Map(this.native_instance, n2, n3, fPoint);
    }

    public void map2Win(float f2, float f3, IPoint iPoint) {
        MapProjection.nativeMap2Win(this.native_instance, f2, f3, iPoint);
    }

    public void win2Map(int n2, int n3, FPoint fPoint) {
        MapProjection.nativeWin2Map(this.native_instance, n2, n3, fPoint);
    }

    public float getMapLenWithWinbyY(int n2, int n3) {
        return MapProjection.nativeGetMapLenWithWinbyY(this.native_instance, n2, n3);
    }

    public float getMapLenWithWin(int n2) {
        return MapProjection.nativeGetMapLenWithWin(this.native_instance, n2);
    }

    public void map2Geo(float f2, float f3, IPoint iPoint) {
        MapProjection.nativeMap2Geo(this.native_instance, f2, f3, iPoint);
    }

    public void setCenterWithMap(float f2, float f3) {
        MapProjection.nativeSetCenterWithMap(this.native_instance, f2, f3);
    }

    public void getCenterMap(FPoint fPoint) {
        MapProjection.nativeGetCenterMap(this.native_instance, fPoint);
    }

    public static void lonlat2Geo(double d2, double d3, IPoint iPoint) {
        MapProjection.nativeLonLat2Geo(d2, d3, iPoint);
    }

    public static void geo2LonLat(int n2, int n3, DPoint dPoint) {
        MapProjection.nativeGeo2LonLat(n2, n3, dPoint);
    }

    public float getMapLenWithGeo(int n2) {
        return MapProjection.nativeGetMapLenWithGeo(this.native_instance, n2);
    }

    public void recalculate() {
        MapProjection.nativeRecalculate(this.native_instance);
    }

    private static native long nativeNewInstance(long var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeGetBound(long var0, IPoint var2);

    private static native void nativeSetGeoCenter(long var0, int var2, int var3);

    private static native void nativeGetGeoCenter(long var0, IPoint var2);

    private static native void nativeSetMapCenter(long var0, float var2, float var3);

    private static native void nativeGetMapCenter(long var0, FPoint var2);

    private static native void nativeSetMapZoomer(long var0, float var2);

    private static native float nativeGetMapZoomer(long var0);

    private static native void nativeSetMapAngle(long var0, float var2);

    private static native float nativeGetMapAngle(long var0);

    private static native void nativeSetCameraHeaderAngle(long var0, float var2);

    private static native float nativeGetCameraHeaderAngle(long var0);

    private static native void nativeGeo2Map(long var0, int var2, int var3, FPoint var4);

    private static native void nativeMap2Win(long var0, float var2, float var3, IPoint var4);

    private static native void nativeWin2Map(long var0, int var2, int var3, FPoint var4);

    private static native float nativeGetMapLenWithWinbyY(long var0, int var2, int var3);

    private static native float nativeGetMapLenWithWin(long var0, int var2);

    private static native void nativeMap2Geo(long var0, float var2, float var3, IPoint var4);

    private static native void nativeSetCenterWithMap(long var0, float var2, float var3);

    private static native void nativeGetCenterMap(long var0, FPoint var2);

    private static native void nativeLonLat2Geo(double var0, double var2, IPoint var4);

    private static native void nativeGeo2LonLat(int var0, int var1, DPoint var2);

    private static native float nativeGetMapLenWithGeo(long var0, int var2);

    private static native void nativeRecalculate(long var0);
}

