/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.content.SharedPreferences;
import com.autonavi.amap.mapcore.Convert;
import com.autonavi.amap.mapcore.FileUtil;
import com.autonavi.amap.mapcore.MapTilsCacheAndResManager;
import com.autonavi.amap.mapcore.ResUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MapTilsCacheAndResManagerImpl
extends MapTilsCacheAndResManager {
    private static volatile MapTilsCacheAndResManagerImpl instance = null;
    private Context mContext;
    private String mMapBaseDataPath;
    private String mMapOfflinePath;
    private String mCachePath;
    private String mMapOnlineTilesPath;
    private String mMapExtResPath;
    private static final long Style_Update_Internal_Time = 43200000L;
    private static final int CREATE_DIR_COUNT = 5;

    public static MapTilsCacheAndResManagerImpl instance(Context context) {
        if (instance == null) {
            instance = new MapTilsCacheAndResManagerImpl(context);
        }
        return instance;
    }

    private MapTilsCacheAndResManagerImpl(Context context) {
        this.mContext = context;
        this.init();
    }

    public synchronized void reset() {
        instance = null;
    }

    public String getBaseMapPath() {
        return this.mMapBaseDataPath;
    }

    public String getMapCachePath() {
        return this.mCachePath;
    }

    public String getMapOnlineDataPath() {
        return this.mMapOnlineTilesPath;
    }

    public String getMapOfflineDataPath() {
        return this.mMapOfflinePath;
    }

    public String getMapExtResPath() {
        return this.mMapExtResPath;
    }

    public byte[] getStyleData(String string, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) {
        try {
            return this.getStyleIconsData(string, 1, retStyleIconsFile);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public byte[] getIconsData(String string, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) {
        try {
            return this.getStyleIconsData(string, 2, retStyleIconsFile);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public byte[] getOtherResData(String string) {
        return ResUtil.decodeAssetResData(this.mContext, "map_assets/" + string);
    }

    public void init() {
        try {
            this.initRelease();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initRelease() {
        File file;
        int n2 = 0;
        File file2 = new File(FileUtil.getMapBaseStorage(this.mContext));
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(file2, "data")).exists()) {
            file.mkdir();
        }
        this.mMapBaseDataPath = file.toString() + "/";
        File file3 = new File(file, "vmap");
        if (!file3.exists()) {
            file3.mkdir();
        }
        this.mMapOfflinePath = file3.toString() + "/";
        File file4 = new File(file, "cache");
        n2 = 0;
        while (!file4.exists() && n2++ < 5) {
            file4.mkdir();
        }
        this.mCachePath = file4.toString() + "/";
        n2 = 0;
        File file5 = new File(file4, "vmap4tiles");
        while (!file5.exists() && n2++ < 5) {
            file5.mkdir();
        }
        this.mMapOnlineTilesPath = file5.toString() + "/";
        n2 = 0;
        File file6 = new File(file4, "vmap4res");
        while (!file6.exists() && n2++ < 5) {
            file6.mkdir();
        }
        this.mMapExtResPath = file6.toString() + "/";
    }

    void initDebug() {
    }

    public void saveFile(String string, int n2, int n3, byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return;
        }
        File file = new File(this.mMapExtResPath);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().contains(string)) continue;
                file2.delete();
                break;
            }
        }
        String string2 = string + "_" + n2 + "_" + n3 + ".data";
        FileUtil.writeDatasToFile(this.mMapExtResPath + string2, byArray);
    }

    private String getFilePreName(String string) {
        String[] stringArray = string.split("_");
        return stringArray[0] + "_" + stringArray[1] + "_" + stringArray[2];
    }

    private void setRetFile(MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile, String string) {
        if (retStyleIconsFile == null) {
            return;
        }
        retStyleIconsFile.fullName = string;
        String[] stringArray = string.split("_|\\.");
        retStyleIconsFile.name = stringArray[0] + "_" + stringArray[1];
        retStyleIconsFile.clientVersion = Integer.parseInt(stringArray[2]);
        retStyleIconsFile.serverVersion = Integer.parseInt(stringArray[3]);
    }

    private byte[] getStyleIconsData(String string, int n2, MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile) throws IOException {
        String string2 = this.getFilePreName(string);
        MapTilsCacheAndResManager.RetStyleIconsFile retStyleIconsFile2 = new MapTilsCacheAndResManager.RetStyleIconsFile();
        this.setRetFile(retStyleIconsFile2, string);
        File[] fileArray = new File(this.mMapExtResPath).listFiles();
        if (fileArray != null) {
            try {
                for (File file : fileArray) {
                    if (!file.getName().contains(string2)) continue;
                    this.setRetFile(retStyleIconsFile, file.getName());
                    if (retStyleIconsFile2.serverVersion < retStyleIconsFile.serverVersion) {
                        byte[] byArray = FileUtil.readFileContents(file.getAbsolutePath());
                        if (byArray == null || byArray.length <= 0) continue;
                        if (n2 == 1) {
                            int n3 = 0;
                            int n4 = Convert.getInt(byArray, n3);
                            n3 += 4;
                            if (byArray.length == n4 + 4) {
                                return byArray;
                            }
                            FileUtil.deleteFile(file);
                            continue;
                        }
                        return byArray;
                    }
                    FileUtil.deleteFile(file);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        this.setRetFile(retStyleIconsFile, string);
        return ResUtil.decodeAssetResData(this.mContext, "map_assets/" + string);
    }

    static void copyAssertToTmp(Context context, String string, File file) {
        if (file.exists()) {
            return;
        }
        try {
            byte[] byArray;
            if (file.createNewFile() && (byArray = ResUtil.decodeAssetResData(context, string)) != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkDir() {
        this.init();
    }

    public void clearOnlineMapTilsCache() {
        File file = new File(this.mMapOnlineTilesPath);
        if (file.exists()) {
            FileUtil.deleteFile(file);
            this.init();
        }
    }

    private void addUdateRecorder(String string) {
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("styles_icons_update_recorder", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(string, System.currentTimeMillis());
        editor.commit();
    }

    public synchronized boolean canUpate(String string) {
        boolean bl2 = true;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("styles_icons_update_recorder", 0);
        long l2 = sharedPreferences.getLong(string, -1L);
        if (l2 > 0L && System.currentTimeMillis() - l2 < 43200000L) {
            bl2 = false;
        }
        if (bl2) {
            this.addUdateRecorder(string);
        }
        return bl2;
    }
}

