/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.autonavi.amap.mapcore.BaseMapCallImplement;
import com.autonavi.amap.mapcore.BaseMapLoader;
import com.autonavi.amap.mapcore.Convert;
import com.autonavi.amap.mapcore.MapCore;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.VMapDataCache;
import com.autonavi.amap.mapcore.VTMCDataCache;
import com.autonavi.amap.mapcore.f;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class NormalMapLoader
extends BaseMapLoader {
    public NormalMapLoader(MapCore mapCore, BaseMapCallImplement baseMapCallImplement, int n2) {
        this.datasource = n2;
        this.mGLMapEngine = mapCore;
        this.mMapCallback = baseMapCallImplement;
        this.createtime = System.currentTimeMillis();
    }

    public String getGridParmaV4() {
        String string = null;
        String string2 = ";";
        for (int i2 = 0; i2 < this.mapTiles.size(); ++i2) {
            String string3 = ((MapSourceGridData)this.mapTiles.get(i2)).getGridName();
            if (string3 == null || string3.length() == 0 || this.containllegal(string3) || !this.isAssic(string3)) continue;
            if (this.datasource == 4 && ((MapSourceGridData)this.mapTiles.get((int)i2)).obj != null) {
                String string4 = (String)((MapSourceGridData)this.mapTiles.get((int)i2)).obj;
                try {
                    string3 = string3 + "-" + URLEncoder.encode(string4, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    continue;
                }
            }
            string = string == null ? string3 + string2 : string + string3 + string2;
        }
        String string5 = string;
        if (string5 == null) {
            return null;
        }
        if (string5.length() > 0) {
            while (string5 != null && (string5.endsWith(string2) || string5.endsWith(" "))) {
                string5 = string.substring(0, string5.length() - 1);
            }
        }
        if (string5.length() <= 0) {
            return null;
        }
        if (this.datasource == 0) {
            return "mapdataver=5&type=20&mesh=" + string5;
        }
        if (this.datasource == 1) {
            return "mapdataver=5&type=11&mesh=" + string5;
        }
        if (this.datasource == 7) {
            return "mapdataver=5&type=1&mesh=" + string5;
        }
        if (this.datasource == 8) {
            return "mapdataver=5&type=13&mesh=" + string5;
        }
        if (this.datasource == 9) {
            return "mapdataver=5&type=40&mesh=" + string5;
        }
        if (this.datasource == 2) {
            return "t=BMPBM&mapdataver=5&mesh=" + string5;
        }
        if (this.datasource == 3) {
            return "mapdataver=5&mesh=" + string5;
        }
        if (this.datasource == 4) {
            return "mapdataver=5&v=6.0.0&bver=2&mesh=" + string5;
        }
        if (this.datasource == 6) {
            return "t=VMMV3&mapdataver=5&type=mod&cp=0&mid=" + string5;
        }
        return null;
    }

    protected String getGridParma() {
        return this.getGridParmaV4();
    }

    protected String getMapSvrPath() {
        String string = null;
        switch (this.datasource) {
            case 4: {
                string = "/ws/mps/rtt?";
                break;
            }
            case 3: {
                string = "/ws/mps/smap?";
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                string = "/ws/mps/vmap?";
                break;
            }
            case 2: 
            case 6: {
                string = "/amapsrv/MPS?";
                break;
            }
        }
        return string;
    }

    protected String getMapAddress() {
        return this.mMapCallback.getMapSvrAddress();
    }

    public boolean isRequestValid() {
        return this.mMapCallback.isGridsInScreen(this.mapTiles, this.datasource);
    }

    protected void processRecivedVersionOrScenicWidgetData() {
        if (this.datasource == 9) {
            this.processRecivedVersionData(this.recievedDataBuffer, 0, this.recievedDataSize);
        }
    }

    protected void processRecivedDataByType() {
        if (this.datasource == 0 || this.datasource == 1 || this.datasource == 8 || this.datasource == 7) {
            this.processReceivedDataV4();
        } else {
            super.processRecivedData();
        }
    }

    protected boolean processReceivedDataHeader(int n2) {
        if (this.recievedDataSize > 7) {
            int n3 = 0;
            int n4 = Convert.getInt(this.recievedDataBuffer, n3);
            if (n4 != 0) {
                this.doCancel();
                return false;
            }
            n3 += 4;
            Convert.moveArray(this.recievedDataBuffer, n3 += 4, this.recievedDataBuffer, 0, n2 - 8);
            this.recievedDataSize -= n3;
            this.nextImgDataLength = 0;
            this.recievedHeader = true;
            if (this.datasource == 0 || this.datasource == 1 || this.datasource == 8 || this.datasource == 7) {
                this.processReceivedDataV4();
            } else {
                super.processRecivedData();
            }
            return true;
        }
        return false;
    }

    protected boolean isNeedProcessReturn() {
        return this.datasource == 9;
    }

    void processRecivedTileData(byte[] byArray, int n2, int n3) {
        if (0 == n2) {
            super.processRecivedTileData(byArray, n2, n3);
        } else if (this.datasource == 2 || this.datasource == 3) {
            this.processRecivedTileDataBmp(byArray, n2, n3);
        } else if (this.datasource == 4) {
            this.processRecivedTileDataVTmc(byArray, n2, n3);
        } else if (this.datasource == 6) {
            this.processRecivedModels(byArray, n2, n3);
        } else {
            super.processRecivedTileData(byArray, n2, n3);
        }
    }

    void processRecivedTileDataBmp(byte[] byArray, int n2, int n3) {
        boolean bl2;
        int n4 = n2;
        n2 += 4;
        byte by2 = byArray[n2++];
        String string = "";
        if (by2 > 0 && n2 + by2 - 1 < n3) {
            string = new String(byArray, n2, (int)by2);
        }
        n2 += by2;
        if (!this.mGLMapEngine.isMapEngineValid()) {
            return;
        }
        if (n3 <= n4) {
            return;
        }
        boolean bl3 = bl2 = !this.mMapCallback.isGridInScreen(this.datasource, string);
        if (this.mGLMapEngine.putMapData(byArray, n4, n3 - n4, this.datasource, 0)) {
            VMapDataCache.getInstance().putRecoder(null, string, this.datasource);
        }
        if (bl2) {
            this.doCancel();
        }
    }

    void processRecivedTileDataVTmc(byte[] byArray, int n2, int n3) {
        boolean bl2;
        byte by2;
        int n4 = n2;
        n2 += 4;
        if (n2 + (by2 = byArray[n2++]) > byArray.length || n2 > byArray.length - 1 || by2 < 0) {
            return;
        }
        String string = new String(byArray, n2, (int)by2);
        n2 += by2;
        byte by3 = byArray[n2++];
        n2 += by3;
        n2 += 4;
        if (!this.mGLMapEngine.isMapEngineValid()) {
            return;
        }
        VTMCDataCache vTMCDataCache = VTMCDataCache.getInstance();
        if (n3 <= n4) {
            return;
        }
        byte[] byArray2 = new byte[n3 - n4];
        System.arraycopy(byArray, n4, byArray2, 0, n3 - n4);
        f f2 = vTMCDataCache.putData(byArray2);
        boolean bl3 = bl2 = !this.mMapCallback.isGridInScreen(this.datasource, string);
        if (f2 != null) {
            this.mGLMapEngine.putMapData(f2.a, 0, f2.a.length, this.datasource, f2.c);
        }
        if (bl2) {
            this.doCancel();
        }
    }

    void processRecivedModels(byte[] byArray, int n2, int n3) {
        byte by2;
        int n4 = n2;
        if ((by2 = byArray[n2++]) < 0) {
            return;
        }
        String string = new String(byArray, n2, (int)by2);
        if (!this.mGLMapEngine.isMapEngineValid()) {
            return;
        }
        if (n3 <= n4) {
            return;
        }
        boolean bl2 = !this.mMapCallback.isGridInScreen(this.datasource, string);
        this.mGLMapEngine.putMapData(byArray, n4, n3 - n4, this.datasource, 0);
        if (bl2) {
            this.doCancel();
        }
    }
}

