/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResUtil {
    public static Bitmap decodeBitmapWithAdaptiveSize(Context context, int n2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        options.inDensity = 0;
        options.inTargetDensity = 0;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2, (BitmapFactory.Options)options);
        bitmap.setDensity(0);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        float f2 = 2.0f / displayMetrics.density;
        if ((double)f2 == 1.0) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() / f2)), (int)((int)((float)bitmap.getHeight() / f2)), (boolean)false);
        bitmap.recycle();
        return bitmap2;
    }

    public static Bitmap decodeAssetBitmap(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            bitmap.setDensity(0);
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap decodeAssetBitmapWithSize(Context context, String string, int n2, int n3) {
        AssetManager assetManager = context.getAssets();
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            Rect rect = new Rect();
            Rect rect2 = new Rect();
            rect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
            rect2.set(0, 0, n2, n3);
            canvas.drawBitmap(bitmap, rect, rect2, null);
            bitmap.recycle();
            bitmap = null;
            return bitmap2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeAssetResData(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = -1;
            while ((n2 = inputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            inputStream.close();
            return byArray2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            float f2 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
            return (int)f2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n2;
        }
    }

    public static int spToPixel(Context context, int n2) {
        float f2 = TypedValue.applyDimension((int)2, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return (int)f2;
    }

    public static String getString(Context context, int n2) {
        return context.getResources().getString(n2);
    }
}

