/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Environment;
import android.text.TextPaint;
import com.autonavi.amap.mapcore.Md5Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TextTextureGenerator {
    static final int TEXT_FONTSIZE = 32;
    static final int TEXT_FONTSIZE_TRUE = 30;
    static final int AN_LABEL_MAXCHARINLINE = 7;
    static final int AN_LABEL_MULITYLINE_SPAN = 2;
    private static final int ALIGNCENTER = 51;
    private static final int ALIGNLEFT = 49;
    private static final int ALIGNRIGHT = 50;
    private float base_line = 0.0f;
    private float start_x = 0.0f;
    private Paint text_paint = TextTextureGenerator.newPaint(null, 30, 49);

    public static int GetNearstSize2N(int n2) {
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3;
    }

    public TextTextureGenerator() {
        Paint.FontMetrics fontMetrics = this.text_paint.getFontMetrics();
        float f2 = fontMetrics.bottom - fontMetrics.top;
        this.base_line = (30.0f - f2) / 2.0f - fontMetrics.top;
    }

    public byte[] getTextPixelBuffer(int n2) {
        try {
            char[] cArray = new char[]{(char)n2};
            Bitmap bitmap = Bitmap.createBitmap((int)32, (int)32, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(bitmap);
            byte[] byArray = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            float f2 = this.text_paint.measureText(cArray[0] + "");
            Paint.Align align = this.text_paint.getTextAlign();
            float f3 = f2 - 30.0f;
            if (align != Paint.Align.CENTER && f3 >= 4.0f) {
                this.text_paint.setTextAlign(Paint.Align.CENTER);
                this.text_paint.setTextSize(30.0f - f3);
                canvas.drawText(cArray, 0, 1, (30.0f - f3) / 2.0f, this.base_line, this.text_paint);
                this.text_paint.setTextAlign(align);
            } else {
                canvas.drawText(cArray, 0, 1, this.start_x, this.base_line - 2.0f, this.text_paint);
            }
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            bitmap.recycle();
            bitmap = null;
            byteBuffer = null;
            return byArray;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte[] getCharsWidths(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2];
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[0] = this.text_paint.measureText((char)nArray[i2] + "");
            byArray[i2] = (byte)(fArray[0] + 1.0f);
        }
        return byArray;
    }

    private static Paint newPaint(String string, int n2, int n3) {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize((float)n2);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTypeface(Typeface.DEFAULT);
        switch (n3) {
            case 51: {
                textPaint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 49: {
                textPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 50: {
                textPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                textPaint.setTextAlign(Paint.Align.LEFT);
            }
        }
        return textPaint;
    }

    public static float getFontlength(Paint paint, String string) {
        return paint.measureText(string);
    }

    public static float getFontHeight(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public static void generaAsccIITexturePng() throws Exception {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        File file = Environment.getExternalStorageDirectory();
        File file2 = new File(file, "asccii.png");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Paint paint = TextTextureGenerator.newPaint(null, 32, 49);
        Bitmap bitmap = Bitmap.createBitmap((int)512, (int)512, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
        Canvas canvas = new Canvas(bitmap);
        paint = TextTextureGenerator.newPaint(null, 32, 49);
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int i3 = 0; i3 < 16; ++i3) {
                char c2 = (char)(i2 * 16 + i3);
                canvas.drawText(c2 + "", (float)(i3 * 16), (float)(i2 * 16 - fontMetricsInt.ascent - 2), paint);
                paint.getTextWidths(c2 + "", fArray);
            }
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
        bitmap.recycle();
        bitmap = null;
    }

    public String getFontVersion() {
        int n2 = 39640;
        byte[] byArray = this.getTextPixelBuffer(n2);
        return Md5Utility.getByteArrayMD5(byArray);
    }
}

