/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.interfaces;

import android.content.Context;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class CameraAnimator {
    private int mMode;
    private int mStartX;
    private int mStartY;
    private float mStartZ;
    private float mStartBearing;
    private float mStartTilt;
    private int mFinalX;
    private int mFinalY;
    private float mFinalZ;
    private float mFinalBearing;
    private float mFinalTilt;
    private int mMinX;
    private int mMaxX;
    private int mMinY;
    private int mMaxY;
    private int mCurrX;
    private int mCurrY;
    private float mCurrZ;
    private float mCurrBearing;
    private float mCurrTilt;
    private long mStartTime;
    private long mDuration;
    private float mDurationReciprocal;
    private float mDeltaX;
    private float mDeltaY;
    private float mDeltaZ;
    private float mDeltaBearing;
    private float mDeltaTilt;
    private boolean mFinished = true;
    private Interpolator mInterpolator;
    private boolean mFlywheel;
    private float mVelocity;
    private float mCurrVelocity;
    private int mDistance;
    private float mFlingFriction = ViewConfiguration.getScrollFriction();
    public static final int DEFAULT_DURATION = 250;
    static final int FLING_MODE = 1;
    public static final int CHANGE_CAMERA_MODE = 2;
    private static float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    private static final float INFLEXION = 0.35f;
    private static final float START_TENSION = 0.5f;
    private static final float END_TENSION = 1.0f;
    private static final float P1 = 0.175f;
    private static final float P2 = 0.35000002f;
    private static final int NB_SAMPLES = 100;
    private static final float[] SPLINE_POSITION = new float[101];
    private static final float[] SPLINE_TIME = new float[101];
    private float mDeceleration;
    private final float mPpi;
    private float mPhysicalCoeff;
    private boolean isUseAnchor;
    private static float sViscousFluidScale;
    private static float sViscousFluidNormalize;

    public CameraAnimator(Context context) {
        this(context, null);
    }

    public CameraAnimator(Context context, Interpolator interpolator) {
        this(context, interpolator, context.getApplicationInfo().targetSdkVersion >= 11);
    }

    public CameraAnimator(Context context, Interpolator interpolator, boolean bl2) {
        this.mInterpolator = interpolator;
        this.mPpi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mDeceleration = this.computeDeceleration(ViewConfiguration.getScrollFriction());
        this.mFlywheel = bl2;
        this.mPhysicalCoeff = this.computeDeceleration(0.84f);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public final void setFriction(float f2) {
        this.mDeceleration = this.computeDeceleration(f2);
        this.mFlingFriction = f2;
    }

    private float computeDeceleration(float f2) {
        return 386.0878f * this.mPpi * f2;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final void forceFinished(boolean bl2) {
        this.mFinished = bl2;
    }

    public final long getDuration() {
        return this.mDuration;
    }

    public final int getCurrX() {
        return this.mCurrX;
    }

    public final int getCurrY() {
        return this.mCurrY;
    }

    public final float getCurrZ() {
        return this.mCurrZ;
    }

    public final float getCurrBearing() {
        return this.mCurrBearing;
    }

    public final float getCurrTilt() {
        return this.mCurrTilt;
    }

    public float getCurrVelocity() {
        return this.mMode == 1 ? this.mCurrVelocity : this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    public final int getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final float getStartZ() {
        return this.mStartZ;
    }

    public final float getStartbearing() {
        return this.mStartBearing;
    }

    public final float getStartTilt() {
        return this.mStartTilt;
    }

    public final int getFinalX() {
        return this.mFinalX;
    }

    public final int getFinalY() {
        return this.mFinalY;
    }

    public final float getFinalZ() {
        return this.mFinalZ;
    }

    public final float getFinalBearing() {
        return this.mFinalBearing;
    }

    public final float getFinalTilt() {
        return this.mFinalTilt;
    }

    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int n2 = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if ((long)n2 < this.mDuration) {
            switch (this.mMode) {
                case 1: {
                    float f2 = (float)n2 / (float)this.mDuration;
                    int n3 = (int)(100.0f * f2);
                    float f3 = 1.0f;
                    float f4 = 0.0f;
                    if (n3 < 100) {
                        float f5 = (float)n3 / 100.0f;
                        float f6 = (float)(n3 + 1) / 100.0f;
                        float f7 = SPLINE_POSITION[n3];
                        float f8 = SPLINE_POSITION[n3 + 1];
                        f4 = (f8 - f7) / (f6 - f5);
                        f3 = f7 + (f2 - f5) * f4;
                    }
                    this.mCurrVelocity = f4 * (float)this.mDistance / (float)this.mDuration * 1000.0f;
                    this.mCurrX = this.mStartX + Math.round(f3 * (float)(this.mFinalX - this.mStartX));
                    this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
                    this.mCurrX = Math.max(this.mCurrX, this.mMinX);
                    this.mCurrY = this.mStartY + Math.round(f3 * (float)(this.mFinalY - this.mStartY));
                    this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
                    this.mCurrY = Math.max(this.mCurrY, this.mMinY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                    break;
                }
                case 2: {
                    float f9 = (float)n2 * this.mDurationReciprocal;
                    f9 = this.mInterpolator == null ? CameraAnimator.viscousFluid(f9) : this.mInterpolator.getInterpolation(f9);
                    this.mCurrX = this.mStartX + Math.round(f9 * this.mDeltaX);
                    this.mCurrY = this.mStartY + Math.round(f9 * this.mDeltaY);
                    this.mCurrZ = this.mStartZ + f9 * this.mDeltaZ;
                    this.mCurrBearing = this.mStartBearing + f9 * this.mDeltaBearing;
                    this.mCurrTilt = this.mStartTilt + f9 * this.mDeltaTilt;
                    break;
                }
            }
        } else {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mCurrZ = this.mFinalZ;
            this.mCurrBearing = this.mFinalBearing;
            this.mCurrTilt = this.mFinalTilt;
            this.mFinished = true;
        }
        return true;
    }

    public void startChangeCamera(int n2, int n3, float f2, float f3, float f4, int n4, int n5, float f5, float f6, float f7) {
        this.startChangeCamera(n2, n3, f2, f3, f4, n4, n5, f5, f6, f7, 250L);
    }

    public void startChangeCamera(int n2, int n3, float f2, float f3, float f4, int n4, int n5, float f5, float f6, float f7, long l2) {
        this.mMode = 2;
        this.mFinished = false;
        this.mDuration = l2;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n2;
        this.mStartY = n3;
        this.mStartZ = f2;
        this.mStartBearing = f3;
        this.mStartTilt = f4;
        this.mFinalX = n2 + n4;
        this.mFinalY = n3 + n5;
        this.mFinalZ = f2 + f5;
        this.mFinalBearing = f3 + f6;
        this.mFinalTilt = f4 + f7;
        this.mDeltaX = n4;
        this.mDeltaY = n5;
        this.mDeltaZ = f5;
        this.mDeltaBearing = f6;
        this.mDeltaTilt = f7;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
    }

    public void fling(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        float f2;
        float f3;
        float f4;
        if (this.mFlywheel && !this.mFinished) {
            f4 = this.getCurrVelocity();
            f3 = this.mFinalX - this.mStartX;
            f2 = this.mFinalY - this.mStartY;
            float f5 = (float)Math.sqrt(f3 * f3 + f2 * f2);
            float f6 = f3 / f5;
            float f7 = f2 / f5;
            float f8 = f6 * f4;
            float f9 = f7 * f4;
            if (Math.signum(n4) == Math.signum(f8) && Math.signum(n5) == Math.signum(f9)) {
                n4 = (int)((float)n4 + f8);
                n5 = (int)((float)n5 + f9);
            }
        }
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = f4 = (float)Math.sqrt(n4 * n4 + n5 * n5);
        this.mDuration = this.getSplineFlingDuration(f4);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = n2;
        this.mStartY = n3;
        f3 = f4 == 0.0f ? 1.0f : (float)n4 / f4;
        f2 = f4 == 0.0f ? 1.0f : (float)n5 / f4;
        double d2 = this.getSplineFlingDistance(f4);
        this.mDistance = (int)(d2 * (double)Math.signum(f4));
        this.mMinX = n6;
        this.mMaxX = n7;
        this.mMinY = n8;
        this.mMaxY = n9;
        this.mFinalX = n2 + (int)Math.round(d2 * (double)f3);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = n3 + (int)Math.round(d2 * (double)f2);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
    }

    private double getSplineDeceleration(float f2) {
        return Math.log(0.35f * Math.abs(f2) / (this.mFlingFriction * this.mPhysicalCoeff));
    }

    private int getSplineFlingDuration(float f2) {
        double d2 = this.getSplineDeceleration(f2);
        double d3 = (double)DECELERATION_RATE - 1.0;
        return (int)(1000.0 * Math.exp(d2 / d3));
    }

    private double getSplineFlingDistance(float f2) {
        double d2 = this.getSplineDeceleration(f2);
        double d3 = (double)DECELERATION_RATE - 1.0;
        return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / d3 * d2);
    }

    static float viscousFluid(float f2) {
        if ((f2 *= sViscousFluidScale) < 1.0f) {
            f2 -= 1.0f - (float)Math.exp(-f2);
        } else {
            float f3 = 0.36787945f;
            f2 = 1.0f - (float)Math.exp(1.0f - f2);
            f2 = f3 + f2 * (1.0f - f3);
        }
        return f2 *= sViscousFluidNormalize;
    }

    public void abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mCurrZ = this.mFinalZ;
        this.mCurrBearing = this.mFinalBearing;
        this.mCurrTilt = this.mFinalTilt;
        this.mFinished = true;
    }

    public void extendDuration(int n2) {
        int n3 = this.timePassed();
        this.mDuration = n3 + n2;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void setFinalX(int n2) {
        this.mFinalX = n2;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    public void setFinalY(int n2) {
        this.mFinalY = n2;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }

    public boolean isScrollingInDirection(float f2, float f3) {
        return !this.mFinished && Math.signum(f2) == Math.signum(this.mFinalX - this.mStartX) && Math.signum(f3) == Math.signum(this.mFinalY - this.mStartY);
    }

    public final int getMode() {
        return this.mMode;
    }

    public void setUseAnchor(boolean bl2) {
        this.isUseAnchor = bl2;
    }

    public boolean isUseAnchor() {
        return this.isUseAnchor;
    }

    static {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 100; ++i2) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = (float)i2 / 100.0f;
            float f10 = 1.0f;
            while (!((double)Math.abs((f8 = (f7 = 3.0f * (f6 = f2 + (f10 - f2) / 2.0f) * (1.0f - f6)) * ((1.0f - f6) * 0.175f + f6 * 0.35000002f) + f6 * f6 * f6) - f9) < 1.0E-5)) {
                if (f8 > f9) {
                    f10 = f6;
                    continue;
                }
                f2 = f6;
            }
            CameraAnimator.SPLINE_POSITION[i2] = f7 * ((1.0f - f6) * 0.5f + f6) + f6 * f6 * f6;
            float f11 = 1.0f;
            while (!((double)Math.abs((f5 = (f7 = 3.0f * (f4 = f3 + (f11 - f3) / 2.0f) * (1.0f - f4)) * ((1.0f - f4) * 0.5f + f4) + f4 * f4 * f4) - f9) < 1.0E-5)) {
                if (f5 > f9) {
                    f11 = f4;
                    continue;
                }
                f3 = f4;
            }
            CameraAnimator.SPLINE_TIME[i2] = f7 * ((1.0f - f4) * 0.175f + f4 * 0.35000002f) + f4 * f4 * f4;
        }
        CameraAnimator.SPLINE_TIME[100] = 1.0f;
        CameraAnimator.SPLINE_POSITION[100] = 1.0f;
        sViscousFluidScale = 8.0f;
        sViscousFluidNormalize = 1.0f;
        sViscousFluidNormalize = 1.0f / CameraAnimator.viscousFluid(1.0f);
    }
}

