/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.interfaces;

import android.graphics.Point;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.IPoint;

public class CameraUpdateFactoryDelegate {
    public Type nowType = Type.none;
    public float xPixel;
    public float yPixel;
    public float zoom;
    public float amount;
    public float tilt;
    public float bearing;
    public CameraPosition cameraPosition;
    public LatLngBounds bounds;
    public int padding;
    public int width;
    public int height;
    public Point focus = null;
    public boolean isUseAnchor = false;
    public IPoint geoPoint;
    public boolean isChangeFinished = false;

    private CameraUpdateFactoryDelegate() {
    }

    public static CameraUpdateFactoryDelegate newInstance() {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = new CameraUpdateFactoryDelegate();
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate zoomIn() {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.zoomIn;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate zoomOut() {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.zoomOut;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate scrollBy(float f2, float f3) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.scrollBy;
        cameraUpdateFactoryDelegate.xPixel = f2;
        cameraUpdateFactoryDelegate.yPixel = f3;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate zoomTo(float f2) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.zoomTo;
        cameraUpdateFactoryDelegate.zoom = f2;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate zoomBy(float f2) {
        return CameraUpdateFactoryDelegate.zoomBy(f2, null);
    }

    public static CameraUpdateFactoryDelegate zoomBy(float f2, Point point) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.zoomBy;
        cameraUpdateFactoryDelegate.amount = f2;
        cameraUpdateFactoryDelegate.focus = point;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate newCameraPosition(CameraPosition cameraPosition) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.newCameraPosition;
        cameraUpdateFactoryDelegate.cameraPosition = cameraPosition;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate changeGeoCenter(IPoint iPoint) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeCenter;
        cameraUpdateFactoryDelegate.geoPoint = iPoint;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate changeTilt(float f2) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeTilt;
        cameraUpdateFactoryDelegate.tilt = f2;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate changeBearing(float f2) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeBearing;
        cameraUpdateFactoryDelegate.bearing = f2;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate changeBearingGeoCenter(float f2, IPoint iPoint) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeBearingGeoCenter;
        cameraUpdateFactoryDelegate.bearing = f2;
        cameraUpdateFactoryDelegate.geoPoint = iPoint;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate changeGeoCenterZoom(IPoint iPoint, float f2) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeGeoCenterZoom;
        cameraUpdateFactoryDelegate.geoPoint = iPoint;
        cameraUpdateFactoryDelegate.zoom = f2;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate newLatLng(LatLng latLng) {
        return CameraUpdateFactoryDelegate.newCameraPosition(CameraPosition.builder().target(latLng).build());
    }

    public static CameraUpdateFactoryDelegate newLatLngZoom(LatLng latLng, float f2) {
        return CameraUpdateFactoryDelegate.newCameraPosition(CameraPosition.builder().target(latLng).zoom(f2).build());
    }

    public static CameraUpdateFactoryDelegate newCamera(LatLng latLng, float f2, float f3, float f4) {
        return CameraUpdateFactoryDelegate.newCameraPosition(CameraPosition.builder().target(latLng).zoom(f2).bearing(f3).tilt(f4).build());
    }

    public static CameraUpdateFactoryDelegate newCamera(IPoint iPoint, float f2, float f3, float f4) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.changeGeoCenterZoomTiltBearing;
        cameraUpdateFactoryDelegate.geoPoint = iPoint;
        cameraUpdateFactoryDelegate.zoom = f2;
        cameraUpdateFactoryDelegate.bearing = f3;
        cameraUpdateFactoryDelegate.tilt = f4;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.newLatLngBounds;
        cameraUpdateFactoryDelegate.bounds = latLngBounds;
        cameraUpdateFactoryDelegate.padding = n2;
        return cameraUpdateFactoryDelegate;
    }

    public static CameraUpdateFactoryDelegate newLatLngBoundsWithSize(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        CameraUpdateFactoryDelegate cameraUpdateFactoryDelegate = CameraUpdateFactoryDelegate.newInstance();
        cameraUpdateFactoryDelegate.nowType = Type.newLatLngBoundsWithSize;
        cameraUpdateFactoryDelegate.bounds = latLngBounds;
        cameraUpdateFactoryDelegate.padding = n4;
        cameraUpdateFactoryDelegate.width = n2;
        cameraUpdateFactoryDelegate.height = n3;
        return cameraUpdateFactoryDelegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        none,
        zoomIn,
        changeCenter,
        changeTilt,
        changeBearing,
        changeBearingGeoCenter,
        changeGeoCenterZoom,
        zoomOut,
        zoomTo,
        zoomBy,
        scrollBy,
        newCameraPosition,
        newLatLngBounds,
        newLatLngBoundsWithSize,
        changeGeoCenterZoomTiltBearing;

    }
}

