/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.amap.api.navi.AMapHudViewListener;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.MyNaviListener;
import com.amap.api.navi.model.AMapLaneInfo;
import com.amap.api.navi.model.AMapNaviCross;
import com.amap.api.navi.model.AMapNaviInfo;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.AMapNaviStaticInfo;
import com.amap.api.navi.model.AMapNaviTrafficFacilityInfo;
import com.amap.api.navi.model.AimLessModeCongestionInfo;
import com.amap.api.navi.model.AimLessModeStat;
import com.amap.api.navi.model.NaviInfo;
import com.amap.api.navi.view.AutoNaviHudMirrorImage;
import com.autonavi.tbt.NaviStaticInfo;
import com.autonavi.tbt.TrafficFacilityInfo;
import com.autonavi.tbt.proguard.ab;
import com.autonavi.tbt.proguard.m;
import com.autonavi.tbt.proguard.n;
import com.autonavi.wtbt.CarLocation;

public class AMapHudView
extends FrameLayout
implements View.OnClickListener,
View.OnTouchListener,
MyNaviListener {
    static final int[] hud_imgActions = new int[]{1191313432, 1191313432, 1191313432, 1191313433, 1191313434, 1191313435, 1191313436, 1191313437, 1191313438, 1191313439, 1191313422, 1191313423, 1191313424, 1191313425, 1191313426, 1191313427, 1191313428, 1191313429, 1191313430, 1191313431};
    private static final long delayMillis = 2000L;
    AMapHudViewListener aMapHudVewListener;
    boolean isLandscape = false;
    private View frameLayout;
    private AMapNavi mAMapNavi;
    private int mWidth = 480;
    private int mHeight = 800;
    private int hudMode = 1;
    private boolean isHudMenu = true;
    private static Handler disappearHudHandler = new Handler();
    private TextView restDistanceTime;
    private String distanceTimeTextStr;
    private TextView limitSpeedTextView;
    private CheckBox mMirrorModeCheckBox;
    private AutoNaviHudMirrorImage autonaviHudMirrorImage;
    private TextView nextRoadNameText;
    private TextView restDistanceText;
    private ImageView roadsignimg;
    private TextView nextRoadDistanceText;
    private View title_btn_goback;
    private View mHudMirrorTitle;
    private Runnable disappearHudTitleRunnable = new Runnable(this){
        private /* synthetic */ AMapHudView a;
        {
            this.a = aMapHudView;
        }

        public final void run() {
            try {
                try {
                    this.a.loadHideHudTitleAnimation();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                ab.b(throwable2, "AMapHudView", "disappearHudTitleRunnable");
                return;
            }
        }
    };
    private CompoundButton.OnCheckedChangeListener mOnCheckedChangeListener = new CompoundButton.OnCheckedChangeListener(this){
        private /* synthetic */ AMapHudView a;
        {
            this.a = aMapHudView;
        }

        public final void onCheckedChanged(CompoundButton object, boolean bl2) {
            try {
                if (this.a.autonaviHudMirrorImage == null) {
                    return;
                }
                if (bl2) {
                    this.a.hudMode = 2;
                } else {
                    this.a.hudMode = 1;
                }
                this.a.setCheckBoxAndMirrorImageState(bl2);
                this.a.removeCallbacks();
                disappearHudHandler.postDelayed(this.a.disappearHudTitleRunnable, 2000L);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
                ab.b((Throwable)object, "AMapHudView", "mOnCheckedChangeListener");
                return;
            }
        }
    };
    private String nextRoadNameTextStr;
    private String restDistanceTextStr;
    private SpannableString nextRoadDisTextSpannableStr = null;
    private int resId;

    public AMapHudView(Context object, AttributeSet attributeSet, int n2) {
        super(object, attributeSet, n2);
        try {
            this.init((Context)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs, int defStyle) ");
            return;
        }
    }

    public AMapHudView(Context object, AttributeSet attributeSet) {
        super(object, attributeSet);
        try {
            this.init((Context)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs) ");
            return;
        }
    }

    public AMapHudView(Context context) {
        super(context);
        this.init(context);
    }

    public int getHudViewMode() {
        return this.hudMode;
    }

    public void setHudViewMode(int n2) {
        try {
            this.hudMode = n2;
            this.setCheckBoxAndMirrorImageState(this.hudMode == 2);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            ab.b(throwable2, "AMapHudView", "setHudViewMode(int mode)");
            return;
        }
    }

    public boolean getHudMenuEnabled() {
        return this.isHudMenu;
    }

    public void setHudMenuEnabled(Boolean bl2) {
        this.isHudMenu = bl2;
    }

    public final void onCreate(Bundle bundle) {
    }

    public final void onResume() {
    }

    public final void onPause() {
    }

    public final void onDestroy() {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
            }
            this.aMapHudVewListener = null;
            if (disappearHudHandler != null) {
                disappearHudHandler.removeCallbacksAndMessages(null);
                disappearHudHandler = null;
            }
            this.mAMapNavi.destroy();
            Log.i((String)"dm", (String)"AmapHudView-->onDestory()");
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            ab.b(throwable2, "AMapHudView", "onDestroy()");
            return;
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
    }

    public void setHudViewListener(AMapHudViewListener aMapHudViewListener) {
        this.aMapHudVewListener = aMapHudViewListener;
    }

    private void init(Context object) {
        try {
            this.mAMapNavi = AMapNavi.getInstance(object);
            this.isLandscape = ((Activity)this.getContext()).getRequestedOrientation() == 0 || this.getResources().getConfiguration().orientation == 2;
            this.frameLayout = this.isLandscape ? n.a((Activity)this.getContext(), 1191378945) : n.a((Activity)this.getContext(), 1191378944);
            this.addView(this.frameLayout);
            this.initResolution();
            this.initWidget();
            this.mAMapNavi.addAMapNaviListener(this);
            this.onNaviInfoUpdate(this.mAMapNavi.getNaviInfo());
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "init(Context context)");
            return;
        }
    }

    private void initResolution() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.mWidth = displayMetrics.widthPixels;
        this.mHeight = displayMetrics.heightPixels;
    }

    public boolean onTouchHudMirrorEvent(MotionEvent object) {
        try {
            if (!this.isHudMenu) {
                return true;
            }
            this.loadShowHudTitleAnimation();
            this.removeCallbacks();
            disappearHudHandler.postDelayed(this.disappearHudTitleRunnable, 2000L);
            return true;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "onTouchHudMirrorEvent(MotionEvent event)");
            return true;
        }
    }

    private void loadShowHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 8) {
            Animation animation = n.a(this.getContext(), 0x47040000);
            this.mHudMirrorTitle.setVisibility(0);
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    private void initWidget() {
        this.mHudMirrorTitle = this.frameLayout.findViewById(0x47070007);
        this.autonaviHudMirrorImage = (AutoNaviHudMirrorImage)this.frameLayout.findViewById(0x47070000);
        this.mMirrorModeCheckBox = (CheckBox)this.frameLayout.findViewById(1191641097);
        this.nextRoadNameText = (TextView)this.frameLayout.findViewById(1191641089);
        this.restDistanceText = (TextView)this.frameLayout.findViewById(0x47070004);
        this.roadsignimg = (ImageView)this.frameLayout.findViewById(1191641090);
        this.nextRoadDistanceText = (TextView)this.frameLayout.findViewById(1191641091);
        this.title_btn_goback = this.frameLayout.findViewById(1191641096);
        this.restDistanceTime = (TextView)this.frameLayout.findViewById(1191641093);
        this.limitSpeedTextView = (TextView)this.frameLayout.findViewById(1191641094);
        this.getScreenInfo();
        this.setWidgetListener();
        this.updateHudWidgetContent();
    }

    private void getScreenInfo() {
        if (this.autonaviHudMirrorImage == null) {
            return;
        }
        this.autonaviHudMirrorImage.mWidth = this.mWidth;
        this.autonaviHudMirrorImage.mHeight = this.mHeight - 50;
    }

    private void updateHudWidgetContent() {
        if (this.nextRoadNameText != null) {
            this.nextRoadNameText.setText((CharSequence)this.nextRoadNameTextStr);
        }
        if (this.nextRoadDistanceText != null) {
            this.nextRoadDistanceText.setText((CharSequence)this.nextRoadDisTextSpannableStr);
        }
        if (this.restDistanceText != null) {
            this.restDistanceText.setText((CharSequence)this.restDistanceTextStr);
        }
        if (this.restDistanceTime != null) {
            this.restDistanceTime.setText((CharSequence)this.distanceTimeTextStr);
        }
        if (this.roadsignimg != null && this.resId != 0 && this.resId != 1) {
            Drawable drawable = n.a().getDrawable(hud_imgActions[this.resId]);
            this.roadsignimg.setBackgroundDrawable(drawable);
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.invalidate();
                this.autonaviHudMirrorImage.postInvalidate();
            }
        }
    }

    private void setWidgetListener() {
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setAMapHudView(this);
            this.setOnTouchListener(this);
        }
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setOnCheckedChangeListener(this.mOnCheckedChangeListener);
        }
        if (this.title_btn_goback != null) {
            this.title_btn_goback.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void removeCallbacks() {
        if (disappearHudHandler != null && this.disappearHudTitleRunnable != null) {
            disappearHudHandler.removeCallbacks(this.disappearHudTitleRunnable);
        }
    }

    private void setCheckBoxAndMirrorImageState(boolean bl2) {
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setChecked(bl2);
        }
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setMirrorState(bl2);
            this.autonaviHudMirrorImage.invalidate();
            this.autonaviHudMirrorImage.postInvalidate();
        }
    }

    private void loadHideHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 0) {
            Animation animation = n.a(this.getContext(), 1191444481);
            animation.setAnimationListener(new Animation.AnimationListener(this){
                private /* synthetic */ AMapHudView a;
                {
                    this.a = aMapHudView;
                }

                public final void onAnimationStart(Animation animation) {
                }

                public final void onAnimationRepeat(Animation animation) {
                }

                public final void onAnimationEnd(Animation animation) {
                    this.a.mHudMirrorTitle.setVisibility(8);
                }
            });
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    private boolean isHudMirror() {
        return this.hudMode == 2;
    }

    protected void onConfigurationChanged(Configuration configuration) {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
                this.autonaviHudMirrorImage = null;
            }
            this.removeAllViews();
            this.frameLayout = this.getResources().getConfiguration().orientation == 2 ? n.a((Activity)this.getContext(), 1191378945) : n.a((Activity)this.getContext(), 1191378944);
            this.addView(this.frameLayout);
            this.initResolution();
            this.initWidget();
            this.getScreenInfo();
            this.onNaviInfoUpdate(this.mAMapNavi.getNaviInfo());
            this.setCheckBoxAndMirrorImageState(this.isHudMirror());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            ab.b(throwable2, "AMapHudView", "onConfigurationChanged(Configuration newConfig)");
        }
        super.onConfigurationChanged(configuration);
    }

    private void updateHudUI(NaviInfo object) {
        if (object == null) {
            return;
        }
        try {
            this.nextRoadNameTextStr = ((NaviInfo)object).m_NextRoadName;
            this.restDistanceTextStr = m.a(((NaviInfo)object).getPathRetainDistance());
            this.nextRoadDisTextSpannableStr = this.switchStrFromMeter(((NaviInfo)object).m_SegRemainDis);
            this.resId = ((NaviInfo)object).m_Icon;
            this.distanceTimeTextStr = m.b(((NaviInfo)object).m_RouteRemainTime);
            if (this.mAMapNavi.getNaviSetting().isMonitorCameraEnabled() && this.mAMapNavi.getEngineType() == 0 && ((NaviInfo)object).getCameraDistance() > 0 && this.limitSpeedTextView != null && ((NaviInfo)object).m_CameraSpeed > 0) {
                this.limitSpeedTextView.setText((CharSequence)("" + ((NaviInfo)object).m_CameraSpeed));
                this.limitSpeedTextView.setVisibility(0);
            } else if (((NaviInfo)object).m_CameraSpeed == 0 && this.limitSpeedTextView != null) {
                this.limitSpeedTextView.setVisibility(8);
            }
            this.updateHudWidgetContent();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "updateHudUI(NaviInfo naviInfo)");
            return;
        }
    }

    private SpannableString switchStrFromMeter(int n2) {
        if (n2 >= 1000) {
            float f2 = (float)Math.round((float)n2 / 1000.0f * 10.0f) / 10.0f;
            return this.getSpanableString(this.getContext(), "" + f2, "\u516c\u91cc");
        }
        return this.getSpanableString(this.getContext(), "" + n2, "\u7c73");
    }

    private SpannableString getSpanableString(Context context, String string, String string2) {
        SpannableString spannableString = new SpannableString((CharSequence)(string + string2));
        int n2 = m.a(context, 60);
        int n3 = m.a(context, 30);
        int n4 = string.length();
        spannableString.setSpan((Object)new AbsoluteSizeSpan(n2), 0, n4, 33);
        spannableString.setSpan((Object)new ForegroundColorSpan(-1), 0, n4, 33);
        int n5 = n4;
        n4 = n5 + string2.length();
        spannableString.setSpan((Object)new AbsoluteSizeSpan(n3), n5, n4, 33);
        spannableString.setSpan((Object)new ForegroundColorSpan(-1), n5, n4, 33);
        return spannableString;
    }

    public void onClick(View object) {
        try {
            if (this.title_btn_goback == object && this.aMapHudVewListener != null) {
                this.aMapHudVewListener.onHudViewCancel();
            }
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "onClick(View v)");
            return;
        }
    }

    public boolean onTouch(View object, MotionEvent motionEvent) {
        try {
            this.onTouchHudMirrorEvent(motionEvent);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "onTouch(View arg0, MotionEvent arg1)");
        }
        return false;
    }

    public void onInitNaviFailure() {
    }

    public void onInitNaviSuccess() {
    }

    public void onStartNavi(int n2) {
    }

    public void onTrafficStatusUpdate() {
    }

    public void onLocationChange(AMapNaviLocation aMapNaviLocation) {
    }

    public void onGetNavigationText(int n2, String string) {
    }

    public void onEndEmulatorNavi() {
    }

    public void onArriveDestination() {
    }

    public void onArriveDestination(NaviStaticInfo naviStaticInfo) {
    }

    public void onArriveDestination(AMapNaviStaticInfo aMapNaviStaticInfo) {
    }

    public void onCalculateRouteSuccess() {
    }

    public void onCalculateRouteFailure(int n2) {
    }

    public void onReCalculateRouteForYaw() {
    }

    public void onReCalculateRouteForTrafficJam() {
    }

    public void onArrivedWayPoint(int n2) {
    }

    public void onGpsOpenStatus(boolean bl2) {
    }

    public void onNaviInfoUpdate(NaviInfo object) {
        try {
            this.updateHudUI((NaviInfo)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "AMapHudView", "onNaviInfoUpdate(NaviInfo naviinfo)");
            return;
        }
    }

    public void OnUpdateTrafficFacility(TrafficFacilityInfo trafficFacilityInfo) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo aMapNaviTrafficFacilityInfo) {
    }

    public void showCross(AMapNaviCross aMapNaviCross) {
    }

    public void hideCross() {
    }

    public void showLaneInfo(AMapLaneInfo[] aMapLaneInfoArray, byte[] byArray, byte[] byArray2) {
    }

    public void hideLaneInfo() {
    }

    public void onCalculateMultipleRoutesSuccess(int[] nArray) {
    }

    public void notifyParallelRoad(int n2) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo[] aMapNaviTrafficFacilityInfoArray) {
    }

    public void updateAimlessModeStatistics(AimLessModeStat aimLessModeStat) {
    }

    public void updateAimlessModeCongestionInfo(AimLessModeCongestionInfo aimLessModeCongestionInfo) {
    }

    public void carProjectionChange(CarLocation carLocation) {
    }

    public void onNaviInfoUpdated(AMapNaviInfo aMapNaviInfo) {
    }
}

