/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.Circle;
import com.amap.api.maps.model.CircleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.NavigateArrow;
import com.amap.api.maps.model.NavigateArrowOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.AMapNaviException;
import com.amap.api.navi.model.AMapNaviPath;
import com.amap.api.navi.model.AMapTrafficStatus;
import com.amap.api.navi.model.NaviLatLng;
import com.amap.api.navi.model.RouteOverlayOptions;
import com.autonavi.tbt.proguard.ab;
import com.autonavi.tbt.proguard.m;
import com.autonavi.tbt.proguard.n;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteOverLay {
    private Bitmap startBitmap;
    private Bitmap endBitmap;
    private Bitmap wayBitmap;
    private BitmapDescriptor startBitmapDescriptor;
    private BitmapDescriptor endBitmapDescriptor;
    private BitmapDescriptor wayPointBitmapDescriptor;
    private Marker startMarker;
    private List<Marker> wayMarkers;
    private Marker endMarker;
    private BitmapDescriptor arrowOnRoute = null;
    private BitmapDescriptor normalRoute = null;
    private BitmapDescriptor unknownTraffic = null;
    private BitmapDescriptor smoothTraffic = null;
    private BitmapDescriptor slowTraffic = null;
    private BitmapDescriptor jamTraffic = null;
    private BitmapDescriptor veryJamTraffic = null;
    private List<Polyline> mTrafficColorfulPolylines = new ArrayList<Polyline>();
    private RouteOverlayOptions mRouteOverlayOptions = null;
    private float mWidth = 40.0f;
    private AMapNaviPath mAMapNaviPath = null;
    private Polyline mDefaultPolyline;
    private AMap aMap;
    private Context mContext;
    private List<LatLng> mLatLngsOfPath;
    private Polyline guideLink = null;
    private List<Circle> gpsCircles = null;
    private boolean emulateGPSLocationVisibility = true;
    private NavigateArrow naviArrow = null;
    private boolean isTrafficLine = true;
    private List<Polyline> mCustomPolylines = new ArrayList<Polyline>();

    public RouteOverLay(AMap aMap, AMapNaviPath aMapNaviPath, Context context) {
        this.mContext = context;
        this.init(aMap, aMapNaviPath);
    }

    public float getWidth() {
        return this.mWidth;
    }

    public void setWidth(float f2) throws AMapNaviException {
        if (f2 <= 0.0f) {
            throw new AMapNaviException("\u975e\u6cd5\u53c2\u6570-\u5bbd\u5ea6\u5fc5\u987b>0");
        }
        this.mWidth = f2;
    }

    public RouteOverlayOptions getRouteOverlayOptions() {
        return this.mRouteOverlayOptions;
    }

    public void setRouteOverlayOptions(RouteOverlayOptions routeOverlayOptions) {
        this.mRouteOverlayOptions = routeOverlayOptions;
        if (routeOverlayOptions != null && routeOverlayOptions.getNormalRoute() != null) {
            this.normalRoute = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getNormalRoute());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getArrowOnTrafficRoute() != null) {
            this.arrowOnRoute = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getArrowOnTrafficRoute());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getUnknownTraffic() != null) {
            this.unknownTraffic = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getUnknownTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getSmoothTraffic() != null) {
            this.smoothTraffic = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getSmoothTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getSlowTraffic() != null) {
            this.slowTraffic = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getSlowTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getJamTraffic() != null) {
            this.jamTraffic = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getJamTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getVeryJamTraffic() != null) {
            this.veryJamTraffic = BitmapDescriptorFactory.fromBitmap((Bitmap)routeOverlayOptions.getVeryJamTraffic());
        }
        if (routeOverlayOptions != null && routeOverlayOptions.getLineWidth() > 0.0f) {
            this.mWidth = routeOverlayOptions.getLineWidth();
        }
    }

    public AMapNaviPath getAMapNaviPath() {
        return this.mAMapNaviPath;
    }

    public void setAMapNaviPath(AMapNaviPath aMapNaviPath) {
        this.mAMapNaviPath = aMapNaviPath;
    }

    @Deprecated
    public void setRouteInfo(AMapNaviPath aMapNaviPath) {
        this.mAMapNaviPath = aMapNaviPath;
    }

    private void init(AMap object, AMapNaviPath aMapNaviPath) {
        try {
            this.aMap = object;
            this.mAMapNaviPath = aMapNaviPath;
            this.normalRoute = BitmapDescriptorFactory.fromAsset((String)"custtexture.png");
        }
        catch (Throwable throwable) {
            object = throwable;
            m.a(throwable);
            ab.b((Throwable)object, "RouteOverLay", "init(AMap amap, AMapNaviPath aMapNaviPath)");
        }
        this.arrowOnRoute = BitmapDescriptorFactory.fromAsset((String)"custtexture_aolr.png");
        this.smoothTraffic = BitmapDescriptorFactory.fromAsset((String)"custtexture_green.png");
        this.unknownTraffic = BitmapDescriptorFactory.fromAsset((String)"custtexture_no.png");
        this.slowTraffic = BitmapDescriptorFactory.fromAsset((String)"custtexture_slow.png");
        this.jamTraffic = BitmapDescriptorFactory.fromAsset((String)"custtexture_bad.png");
        this.veryJamTraffic = BitmapDescriptorFactory.fromAsset((String)"custtexture_grayred.png");
    }

    public void addToMap() {
        try {
            int n2;
            Object object;
            Object object22;
            if (this.aMap == null) {
                return;
            }
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
                this.mDefaultPolyline = null;
            }
            if (this.mWidth == 0.0f || this.mAMapNaviPath == null) {
                return;
            }
            if (this.naviArrow != null) {
                this.naviArrow.setVisible(false);
            }
            if ((object22 = this.mAMapNaviPath.getCoordList()) == null) {
                return;
            }
            int n3 = object22.size();
            this.mLatLngsOfPath = new ArrayList<LatLng>(n3);
            object22 = object22.iterator();
            while (object22.hasNext()) {
                NaviLatLng naviLatLng = (NaviLatLng)object22.next();
                object = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude(), false);
                this.mLatLngsOfPath.add((LatLng)object);
            }
            if (this.mLatLngsOfPath.size() == 0) {
                return;
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
            this.mDefaultPolyline = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).setCustomTexture(this.normalRoute).width(this.mWidth));
            this.mDefaultPolyline.setVisible(true);
            object22 = null;
            LatLng latLng = null;
            object = null;
            if (this.mAMapNaviPath.getStartPoint() != null && this.mAMapNaviPath.getEndPoint() != null) {
                object22 = new LatLng(this.mAMapNaviPath.getStartPoint().getLatitude(), this.mAMapNaviPath.getStartPoint().getLongitude());
                latLng = new LatLng(this.mAMapNaviPath.getEndPoint().getLatitude(), this.mAMapNaviPath.getEndPoint().getLongitude());
                object = this.mAMapNaviPath.getWayPoint();
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            if (this.wayMarkers != null && this.wayMarkers.size() > 0) {
                for (n2 = 0; n2 < this.wayMarkers.size(); ++n2) {
                    Marker marker = this.wayMarkers.get(n2);
                    if (marker == null) continue;
                    marker.remove();
                }
            }
            if (this.startBitmap == null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object22).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313528))));
            } else if (this.startBitmapDescriptor != null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)object22).icon(this.startBitmapDescriptor));
            }
            if (object != null && object.size() > 0) {
                n2 = object.size();
                if (this.wayMarkers == null) {
                    this.wayMarkers = new ArrayList<Marker>(n2);
                }
                for (Object object22 : object) {
                    object22 = new LatLng(((NaviLatLng)object22).getLatitude(), ((NaviLatLng)object22).getLongitude());
                    object = null;
                    if (this.wayBitmap == null) {
                        object = this.aMap.addMarker(new MarkerOptions().position((LatLng)object22).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313535))));
                    } else if (this.wayPointBitmapDescriptor != null) {
                        object = this.aMap.addMarker(new MarkerOptions().position((LatLng)object22).icon(this.wayPointBitmapDescriptor));
                    }
                    this.wayMarkers.add((Marker)object);
                }
            }
            if (this.endBitmap == null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313417))));
            } else if (this.endBitmapDescriptor != null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(this.endBitmapDescriptor));
            }
            if (this.isTrafficLine) {
                this.setTrafficLine(this.isTrafficLine);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            m.a(throwable);
            ab.b(throwable2, "RouteOverLay", "addToMap()");
            return;
        }
    }

    public void drawGuideLink(LatLng latLng, LatLng latLng2, boolean bl2) {
        if (bl2) {
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>(2);
            arrayList.add(latLng);
            arrayList.add(latLng2);
            if (this.guideLink == null) {
                this.guideLink = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth / 3.0f).setDottedLine(true));
            } else {
                this.guideLink.setPoints(arrayList);
            }
            this.guideLink.setVisible(true);
            return;
        }
        if (this.guideLink != null) {
            this.guideLink.setVisible(false);
        }
    }

    public void drawEmulateGPSLocation(Vector<String> latLng) {
        try {
            Iterator<Object> iterator;
            if (this.gpsCircles == null) {
                this.gpsCircles = new ArrayList<Circle>(latLng.size());
            } else {
                iterator = this.gpsCircles.iterator();
                while (iterator.hasNext()) {
                    iterator.next().remove();
                }
                this.gpsCircles.clear();
            }
            iterator = latLng.iterator();
            while (iterator.hasNext()) {
                latLng = ((String)iterator.next()).split(",");
                if (latLng == null || ((String[])latLng).length < 11) continue;
                latLng = new LatLng(Double.parseDouble(latLng[0]), Double.parseDouble(latLng[1]));
                latLng = this.aMap.addCircle(new CircleOptions().center(latLng).radius(1.5).strokeWidth(0.0f).fillColor(-65536));
                this.gpsCircles.add((Circle)latLng);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            ab.b(exception2, "RouteOverLay", "drawEmulateGPSLocation(Vector<String> gpsData)");
            return;
        }
    }

    public void setEmulateGPSLocationVisible() {
        if (this.gpsCircles != null) {
            this.emulateGPSLocationVisibility = !this.emulateGPSLocationVisibility;
            Iterator<Circle> iterator = this.gpsCircles.iterator();
            while (iterator.hasNext()) {
                iterator.next().setVisible(this.emulateGPSLocationVisibility);
            }
        }
    }

    public void setStartPointBitmap(Bitmap bitmap) {
        this.startBitmap = bitmap;
        if (this.startBitmap != null) {
            this.startBitmapDescriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)this.startBitmap);
        }
    }

    public void setWayPointBitmap(Bitmap bitmap) {
        this.wayBitmap = bitmap;
        if (this.wayBitmap != null) {
            this.wayPointBitmapDescriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)this.wayBitmap);
        }
    }

    public void setEndPointBitmap(Bitmap bitmap) {
        this.endBitmap = bitmap;
        if (this.endBitmap != null) {
            this.endBitmapDescriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)this.endBitmap);
        }
    }

    public void removeFromMap() {
        try {
            Iterator<Marker> iterator;
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.setVisible(false);
            }
            if (this.startMarker != null) {
                this.startMarker.setVisible(false);
            }
            if (this.wayMarkers != null) {
                iterator = this.wayMarkers.iterator();
                while (iterator.hasNext()) {
                    iterator.next().setVisible(false);
                }
            }
            if (this.endMarker != null) {
                this.endMarker.setVisible(false);
            }
            if (this.naviArrow != null) {
                this.naviArrow.remove();
            }
            if (this.guideLink != null) {
                this.guideLink.setVisible(false);
            }
            if (this.gpsCircles != null) {
                iterator = this.gpsCircles.iterator();
                while (iterator.hasNext()) {
                    ((Circle)iterator.next()).setVisible(false);
                }
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            m.a(throwable);
            ab.b(throwable2, "RouteOverLay", "removeFromMap()");
            return;
        }
    }

    private void clearTrafficLineAndInvisibleOriginalLine() {
        int n2;
        if (this.mTrafficColorfulPolylines.size() > 0) {
            for (n2 = 0; n2 < this.mTrafficColorfulPolylines.size(); ++n2) {
                if (this.mTrafficColorfulPolylines.get(n2) == null) continue;
                this.mTrafficColorfulPolylines.get(n2).remove();
            }
        }
        this.mTrafficColorfulPolylines.clear();
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setVisible(false);
        }
        if (this.mCustomPolylines.size() > 0) {
            for (n2 = 0; n2 < this.mCustomPolylines.size(); ++n2) {
                if (this.mCustomPolylines.get(n2) == null) continue;
                this.mCustomPolylines.get(n2).setVisible(false);
            }
        }
    }

    private void colorWayUpdate(List<AMapTrafficStatus> list) {
        if (this.aMap == null) {
            return;
        }
        if (this.mLatLngsOfPath == null || this.mLatLngsOfPath.size() <= 0) {
            return;
        }
        if (list == null || list.size() <= 0) {
            return;
        }
        this.clearTrafficLineAndInvisibleOriginalLine();
        int n2 = 0;
        Object object = this.mLatLngsOfPath.get(0);
        LatLng latLng = null;
        double d2 = 0.0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Polyline polyline = null;
        for (int i2 = 0; i2 < this.mLatLngsOfPath.size() && n2 < list.size(); ++i2) {
            double d3;
            AMapTrafficStatus aMapTrafficStatus = list.get(n2);
            latLng = this.mLatLngsOfPath.get(i2);
            object = new NaviLatLng(((LatLng)object).latitude, ((LatLng)object).longitude);
            NaviLatLng naviLatLng = new NaviLatLng(latLng.latitude, latLng.longitude);
            double d4 = m.a((NaviLatLng)object, naviLatLng);
            d2 += d4;
            if (d3 > (double)(aMapTrafficStatus.getLength() + 1)) {
                double d5 = d4 - (d2 - (double)aMapTrafficStatus.getLength());
                object = m.a((NaviLatLng)object, naviLatLng, d5);
                object = new LatLng(((NaviLatLng)object).getLatitude(), ((NaviLatLng)object).getLongitude());
                arrayList.add(object);
                --i2;
            } else {
                arrayList.add(latLng);
                object = latLng;
            }
            if (!(d2 >= (double)aMapTrafficStatus.getLength()) && i2 != this.mLatLngsOfPath.size() - 1) continue;
            if (n2 == list.size() - 1 && i2 < this.mLatLngsOfPath.size() - 1) {
                ++i2;
                while (i2 < this.mLatLngsOfPath.size()) {
                    LatLng latLng2 = this.mLatLngsOfPath.get(i2);
                    arrayList.add(latLng2);
                    ++i2;
                }
            }
            ++n2;
            switch (aMapTrafficStatus.getStatus()) {
                case 0: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.unknownTraffic));
                    break;
                }
                case 1: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.smoothTraffic));
                    break;
                }
                case 2: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.slowTraffic));
                    break;
                }
                case 3: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.jamTraffic));
                    break;
                }
                case 4: {
                    polyline = this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).width(this.mWidth).setCustomTexture(this.veryJamTraffic));
                }
            }
            this.mTrafficColorfulPolylines.add(polyline);
            arrayList.clear();
            arrayList.add(object);
            d2 = 0.0;
        }
        polyline = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).width(this.mWidth).setCustomTexture(this.arrowOnRoute));
        this.mTrafficColorfulPolylines.add(polyline);
    }

    public void zoomToSpan() {
        this.zoomToSpan(100);
    }

    public void zoomToSpan(int n2) {
        try {
            if (this.mAMapNaviPath == null) {
                return;
            }
            CameraUpdate cameraUpdate = CameraUpdateFactory.newLatLngBounds((LatLngBounds)this.mAMapNaviPath.getBoundsForPath(), (int)n2);
            this.aMap.animateCamera(cameraUpdate, 1000L, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            m.a(throwable);
            ab.b(throwable2, "RouteOverLay", "zoomToSpan()");
            return;
        }
    }

    public void destroy() {
        try {
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
            }
            this.mAMapNaviPath = null;
            if (this.arrowOnRoute != null) {
                this.arrowOnRoute.recycle();
            }
            if (this.smoothTraffic != null) {
                this.smoothTraffic.recycle();
            }
            if (this.unknownTraffic != null) {
                this.unknownTraffic.recycle();
            }
            if (this.slowTraffic != null) {
                this.slowTraffic.recycle();
            }
            if (this.jamTraffic != null) {
                this.jamTraffic.recycle();
            }
            if (this.veryJamTraffic != null) {
                this.veryJamTraffic.recycle();
            }
            if (this.startBitmap != null) {
                this.startBitmap.recycle();
            }
            if (this.endBitmap != null) {
                this.endBitmap.recycle();
            }
            if (this.wayBitmap != null) {
                this.wayBitmap.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            m.a(throwable);
            ab.b(throwable2, "RouteOverLay", "destroy()");
            return;
        }
    }

    public void drawArrow(List<NaviLatLng> object) {
        try {
            if (object == null) {
                this.naviArrow.setVisible(false);
                return;
            }
            int n2 = object.size();
            ArrayList<NaviLatLng> arrayList = new ArrayList<NaviLatLng>(n2);
            object = object.iterator();
            while (object.hasNext()) {
                NaviLatLng naviLatLng = (NaviLatLng)object.next();
                naviLatLng = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude(), false);
                arrayList.add(naviLatLng);
            }
            if (this.naviArrow == null) {
                this.naviArrow = this.aMap.addNavigateArrow(new NavigateArrowOptions().addAll(arrayList).width(this.mWidth * 0.6f));
            } else {
                this.naviArrow.setPoints(arrayList);
            }
            this.naviArrow.setZIndex(1.0f);
            this.naviArrow.setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            ab.b(throwable2, "RouteOverLay", "drawArrow(List<NaviLatLng> list) ");
            return;
        }
    }

    public List<NaviLatLng> getArrowPoints(int n2) {
        if (this.mAMapNaviPath == null) {
            return null;
        }
        try {
            int n3;
            NaviLatLng naviLatLng;
            int n4;
            if (n2 >= this.mAMapNaviPath.getStepsCount()) {
                return null;
            }
            List<NaviLatLng> list = this.mAMapNaviPath.getCoordList();
            int n5 = list.size();
            n2 = this.mAMapNaviPath.getSteps().get(n2).getEndIndex();
            NaviLatLng naviLatLng2 = list.get(n2);
            Vector<NaviLatLng> vector = new Vector<NaviLatLng>();
            NaviLatLng naviLatLng3 = naviLatLng2;
            int n6 = 0;
            for (n4 = n2 - 1; n4 >= 0; --n4) {
                naviLatLng = list.get(n4);
                n3 = m.a(naviLatLng3, naviLatLng);
                if ((n6 += n3) >= 50) {
                    naviLatLng3 = m.a(naviLatLng3, naviLatLng, n3 + 50 - n6);
                    vector.add(naviLatLng3);
                    break;
                }
                naviLatLng3 = naviLatLng;
                vector.add(naviLatLng);
            }
            Collections.reverse(vector);
            vector.add(naviLatLng2);
            n6 = 0;
            naviLatLng3 = naviLatLng2;
            for (n4 = n2 + 1; n4 < n5; ++n4) {
                naviLatLng = list.get(n4);
                n3 = m.a(naviLatLng3, naviLatLng);
                if ((n6 += n3) >= 50) {
                    naviLatLng3 = m.a(naviLatLng3, naviLatLng, n3 + 50 - n6);
                    vector.add(naviLatLng3);
                    break;
                }
                naviLatLng3 = naviLatLng;
                vector.add(naviLatLng);
            }
            if (vector.size() > 2) {
                return vector;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            ab.b(exception2, "RouteOverLay", "getArrowPoints(int roadIndex)");
        }
        return null;
    }

    public boolean isTrafficLine() {
        return this.isTrafficLine;
    }

    public void setTrafficLine(Boolean object) {
        try {
            if (this.mContext == null) {
                return;
            }
            this.isTrafficLine = (Boolean)object;
            object = null;
            this.clearTrafficLineAndInvisibleOriginalLine();
            if (this.isTrafficLine) {
                if (this.mAMapNaviPath != null) {
                    object = AMapNavi.getInstance(this.mContext).getTrafficStatuses(0, this.mAMapNaviPath.getAllLength());
                }
                if (object == null) {
                    this.NoTrafficStatusDisplay();
                    return;
                }
                this.colorWayUpdate((List<AMapTrafficStatus>)object);
                return;
            }
            this.NoTrafficStatusDisplay();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            ab.b((Throwable)object, "RouteOverLay", "setTrafficLine(Boolean enabled)");
            return;
        }
    }

    private void NoTrafficStatusDisplay() {
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setVisible(true);
        }
        if (this.mCustomPolylines.size() > 0) {
            for (int i2 = 0; i2 < this.mCustomPolylines.size(); ++i2) {
                if (this.mCustomPolylines.get(i2) == null) continue;
                this.mCustomPolylines.get(i2).setVisible(true);
            }
        }
    }

    private void addToMap(int[] nArray, int[] object, BitmapDescriptor[] marker) {
        try {
            Object object2;
            NaviLatLng naviLatLng;
            List<NaviLatLng> list;
            if (this.aMap == null) {
                return;
            }
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.remove();
                this.mDefaultPolyline = null;
            }
            if (this.mWidth == 0.0f || this.mAMapNaviPath == null || this.normalRoute == null) {
                return;
            }
            if (this.naviArrow != null) {
                this.naviArrow.setVisible(false);
            }
            if ((list = this.mAMapNaviPath.getCoordList()) == null) {
                return;
            }
            this.clearTrafficLineAndInvisibleOriginalLine();
            int n2 = list.size();
            this.mLatLngsOfPath = new ArrayList<LatLng>(n2);
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            int n3 = 0;
            int n4 = nArray == null ? ((BitmapDescriptor[])marker).length : nArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (object != null && i2 < ((int[])object).length && object[i2] <= 0) continue;
                arrayList.clear();
                while (n3 < list.size()) {
                    naviLatLng = list.get(n3);
                    object2 = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude(), false);
                    this.mLatLngsOfPath.add((LatLng)object2);
                    arrayList.add((LatLng)object2);
                    if (object != null && i2 < ((int[])object).length && n3 == object[i2]) break;
                    ++n3;
                }
                naviLatLng = marker == null || ((BitmapDescriptor[])marker).length == 0 ? this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).color(nArray[i2]).width(this.mWidth)) : this.aMap.addPolyline(new PolylineOptions().addAll(arrayList).setCustomTexture(marker[i2]).width(this.mWidth));
                naviLatLng.setVisible(true);
                this.mCustomPolylines.add((Polyline)naviLatLng);
            }
            naviLatLng = this.aMap.addPolyline(new PolylineOptions().addAll(this.mLatLngsOfPath).width(this.mWidth).setCustomTexture(this.arrowOnRoute));
            this.mCustomPolylines.add((Polyline)naviLatLng);
            LatLng latLng = null;
            naviLatLng = null;
            object2 = null;
            if (this.mAMapNaviPath.getStartPoint() != null && this.mAMapNaviPath.getEndPoint() != null) {
                latLng = new LatLng(this.mAMapNaviPath.getStartPoint().getLatitude(), this.mAMapNaviPath.getStartPoint().getLongitude());
                naviLatLng = new LatLng(this.mAMapNaviPath.getEndPoint().getLatitude(), this.mAMapNaviPath.getEndPoint().getLongitude());
                object2 = this.mAMapNaviPath.getWayPoint();
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            if (this.wayMarkers != null && this.wayMarkers.size() > 0) {
                for (int i3 = 0; i3 < this.wayMarkers.size(); ++i3) {
                    Marker marker2 = this.wayMarkers.get(i3);
                    object = marker2;
                    if (marker2 == null) continue;
                    object.remove();
                }
            }
            if (this.startBitmap == null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313528))));
            } else if (this.startBitmapDescriptor != null) {
                this.startMarker = this.aMap.addMarker(new MarkerOptions().position(latLng).icon(this.startBitmapDescriptor));
            }
            if (object2 != null && object2.size() > 0) {
                int n5 = object2.size();
                if (this.wayMarkers == null) {
                    this.wayMarkers = new ArrayList<Marker>(n5);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    NaviLatLng naviLatLng2 = (NaviLatLng)object.next();
                    naviLatLng2 = new LatLng(naviLatLng2.getLatitude(), naviLatLng2.getLongitude());
                    marker = null;
                    if (this.wayBitmap == null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position((LatLng)naviLatLng2).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313535))));
                    } else if (this.wayPointBitmapDescriptor != null) {
                        marker = this.aMap.addMarker(new MarkerOptions().position((LatLng)naviLatLng2).icon(this.wayPointBitmapDescriptor));
                    }
                    this.wayMarkers.add(marker);
                }
            }
            if (this.endBitmap == null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)naviLatLng).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)n.a(), (int)1191313417))));
            } else if (this.endBitmapDescriptor != null) {
                this.endMarker = this.aMap.addMarker(new MarkerOptions().position((LatLng)naviLatLng).icon(this.endBitmapDescriptor));
            }
            if (this.isTrafficLine) {
                this.setTrafficLine(this.isTrafficLine);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            m.a(throwable);
            ab.b(throwable2, "RouteOverLay", "addToMap(int[] color, int[] index, BitmapDescriptor[] resourceArray)");
            return;
        }
    }

    public void addToMap(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.addToMap(nArray, nArray2, null);
    }

    public void addToMap(BitmapDescriptor[] bitmapDescriptorArray, int[] nArray) {
        if (bitmapDescriptorArray == null || bitmapDescriptorArray.length == 0) {
            return;
        }
        this.addToMap(null, nArray, bitmapDescriptorArray);
    }

    public void setTransparency(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (this.mDefaultPolyline != null) {
            this.mDefaultPolyline.setTransparency(f2);
        }
        Iterator<Polyline> iterator = this.mTrafficColorfulPolylines.iterator();
        while (iterator.hasNext()) {
            iterator.next().setTransparency(f2);
        }
    }

    public void setZindex(int n2) {
        try {
            if (this.mTrafficColorfulPolylines != null) {
                for (int i2 = 0; i2 < this.mTrafficColorfulPolylines.size(); ++i2) {
                    this.mTrafficColorfulPolylines.get(i2).setZIndex((float)n2);
                }
            }
            if (this.mDefaultPolyline != null) {
                this.mDefaultPolyline.setZIndex((float)n2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

