/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.amap.api.navi.model.AMapTrafficStatus;
import com.autonavi.tbt.proguard.n;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrafficBarView
extends ImageView {
    private int left;
    private int right;
    private int progressBarHeight;
    private Paint paint;
    private Bitmap displayingBitmap;
    private Bitmap tmcBarBitmapPortrait;
    private Bitmap tmcBarBitmapLandscape;
    private List<AMapTrafficStatus> mTmcSections;
    private int tmcBarTopMargin = 30;
    private Bitmap rawBitmap;
    private int totalDis = 0;
    private RectF colorRectF;
    private int drawTmcBarBgX;
    private int drawTmcBarBgY;
    private int tmcBarBgWidth;
    private int tmcBarBgHeight = 0;
    private int unknownTrafficColor;
    private int smoothTrafficColor;
    private int slowTrafficColor;
    private int jamTrafficColor;
    private int veryJamTrafficColor;

    public TrafficBarView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initResource();
    }

    public TrafficBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initResource();
    }

    public TrafficBarView(Context context) {
        super(context);
        this.initResource();
    }

    public Bitmap getDisplayingBitmap() {
        return this.displayingBitmap;
    }

    private void initResource() {
        this.tmcBarBitmapPortrait = this.rawBitmap = BitmapFactory.decodeResource((Resources)n.a(), (int)1191313502);
        this.left = this.tmcBarBitmapPortrait.getWidth() * 20 / 100;
        this.right = this.tmcBarBitmapPortrait.getWidth() * 80 / 100;
        this.progressBarHeight = (int)((double)this.tmcBarBitmapPortrait.getHeight() * 0.8);
        this.tmcBarBgWidth = this.tmcBarBitmapPortrait.getWidth();
        this.tmcBarBgHeight = this.tmcBarBitmapPortrait.getHeight();
        this.paint = new Paint();
        this.tmcBarTopMargin = Build.VERSION.SDK_INT >= 11 ? Math.abs(this.progressBarHeight - this.tmcBarBitmapPortrait.getHeight()) / 4 - (int)((double)this.progressBarHeight * 0.017) : Math.abs(this.progressBarHeight - this.tmcBarBitmapPortrait.getHeight()) / 4 - 3;
        this.setTmcBarHeightWhenLandscape(0.6666666666666666);
        this.displayingBitmap = this.tmcBarBitmapPortrait;
        this.colorRectF = new RectF();
        this.unknownTrafficColor = Color.parseColor((String)"#B3CCDD");
        this.smoothTrafficColor = Color.parseColor((String)"#05C300");
        this.slowTrafficColor = Color.parseColor((String)"#FFD615");
        this.jamTrafficColor = Color.argb((int)255, (int)255, (int)93, (int)91);
        this.veryJamTrafficColor = Color.argb((int)255, (int)179, (int)17, (int)15);
    }

    public void onConfigurationChanged(boolean bl2) {
        this.displayingBitmap = bl2 ? this.tmcBarBitmapLandscape : this.tmcBarBitmapPortrait;
        this.setProgressBarSize(bl2);
    }

    private void setProgressBarSize(boolean bl2) {
        this.progressBarHeight = (int)((double)this.displayingBitmap.getHeight() * 0.8);
        this.tmcBarBgWidth = this.displayingBitmap.getWidth();
        this.tmcBarBgHeight = this.displayingBitmap.getHeight();
        if (!bl2 && Build.VERSION.SDK_INT < 11) {
            this.tmcBarTopMargin = Math.abs(this.progressBarHeight - this.displayingBitmap.getHeight()) / 4 - 4;
            return;
        }
        this.tmcBarTopMargin = Math.abs(this.progressBarHeight - this.displayingBitmap.getHeight()) / 4 - (int)((double)this.progressBarHeight * 0.017);
    }

    public void update(List<AMapTrafficStatus> list, int n2) {
        this.mTmcSections = list;
        this.totalDis = n2;
        if (this.produceFinalBitmap() != null) {
            this.setImageBitmap(this.produceFinalBitmap());
        }
    }

    public int getUnknownTrafficColor() {
        return this.unknownTrafficColor;
    }

    public void setUnknownTrafficColor(int n2) {
        this.unknownTrafficColor = n2;
    }

    public int getSmoothTrafficColor() {
        return this.smoothTrafficColor;
    }

    public void setSmoothTrafficColor(int n2) {
        this.smoothTrafficColor = n2;
    }

    public int getSlowTrafficColor() {
        return this.slowTrafficColor;
    }

    public void setSlowTrafficColor(int n2) {
        this.slowTrafficColor = n2;
    }

    public int getJamTrafficColor() {
        return this.jamTrafficColor;
    }

    public void setJamTrafficColor(int n2) {
        this.jamTrafficColor = n2;
    }

    public int getVeryJamTrafficColor() {
        return this.veryJamTrafficColor;
    }

    public void setVeryJamTrafficColor(int n2) {
        this.veryJamTrafficColor = n2;
    }

    Bitmap produceFinalBitmap() {
        if (this.mTmcSections == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.displayingBitmap.getWidth(), (int)this.displayingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.paint.setStyle(Paint.Style.FILL);
        float f2 = this.totalDis;
        for (int i2 = 0; i2 < this.mTmcSections.size(); ++i2) {
            AMapTrafficStatus aMapTrafficStatus = this.mTmcSections.get(i2);
            switch (aMapTrafficStatus.getStatus()) {
                case 0: {
                    this.paint.setColor(this.unknownTrafficColor);
                    break;
                }
                case 1: {
                    this.paint.setColor(this.smoothTrafficColor);
                    break;
                }
                case 2: {
                    this.paint.setColor(this.slowTrafficColor);
                    break;
                }
                case 3: {
                    this.paint.setColor(this.jamTrafficColor);
                    break;
                }
                case 4: {
                    this.paint.setColor(this.veryJamTrafficColor);
                    break;
                }
                default: {
                    this.paint.setColor(this.unknownTrafficColor);
                }
            }
            if (f2 - (float)aMapTrafficStatus.getLength() > 0.0f) {
                this.colorRectF.set((float)this.left, (float)this.progressBarHeight * (f2 - (float)aMapTrafficStatus.getLength()) / (float)this.totalDis + (float)this.tmcBarTopMargin, (float)this.right, (float)this.progressBarHeight * f2 / (float)this.totalDis + (float)this.tmcBarTopMargin);
            } else {
                this.colorRectF.set((float)this.left, (float)this.tmcBarTopMargin, (float)this.right, (float)this.progressBarHeight * f2 / (float)this.totalDis + (float)this.tmcBarTopMargin);
            }
            if (i2 == this.mTmcSections.size() - 1) {
                this.colorRectF.set((float)this.left, (float)this.tmcBarTopMargin, (float)this.right, (float)this.progressBarHeight * f2 / (float)this.totalDis + (float)this.tmcBarTopMargin);
            }
            canvas.drawRect(this.colorRectF, this.paint);
            f2 -= (float)aMapTrafficStatus.getLength();
        }
        this.paint.setColor(-65536);
        canvas.drawBitmap(this.displayingBitmap, 0.0f, 0.0f, null);
        return bitmap;
    }

    public void setTmcBarPosition(int n2, int n3, int n4, int n5, boolean bl2) {
        this.setTmcBarHeightWhenLandscape(0.6666666666666666 * (double)n3 / (double)n4);
        this.setTmcBarHeightWhenPortrait(1.0 * (double)n3 / (double)n4);
        n5 = n5 * n3 / n4;
        this.onConfigurationChanged(bl2);
        if (bl2) {
            this.drawTmcBarBgX = Math.abs(n2 - (int)(1.3 * (double)this.tmcBarBgWidth));
            this.drawTmcBarBgY = (n3 - this.tmcBarBgHeight / 2) * 6 / 10;
            return;
        }
        this.drawTmcBarBgX = Math.abs(n2 - (int)(1.3 * (double)this.tmcBarBgWidth));
        this.drawTmcBarBgY = (int)((double)n3 - 1.5 * (double)n5 - (double)this.tmcBarBgHeight);
    }

    public void setTmcBarHeightWhenLandscape(double d2) {
        if (d2 > 1.0) {
            d2 = 1.0;
        } else if (d2 < 0.1) {
            d2 = 0.1;
        }
        this.tmcBarBitmapLandscape = Bitmap.createScaledBitmap((Bitmap)this.rawBitmap, (int)this.rawBitmap.getWidth(), (int)((int)((double)this.rawBitmap.getHeight() * d2)), (boolean)true);
    }

    public void setTmcBarHeightWhenPortrait(double d2) {
        if (d2 > 1.0) {
            d2 = 1.0;
        } else if (d2 < 0.1) {
            d2 = 0.1;
        }
        this.displayingBitmap = this.tmcBarBitmapPortrait = Bitmap.createScaledBitmap((Bitmap)this.rawBitmap, (int)this.rawBitmap.getWidth(), (int)((int)((double)this.rawBitmap.getHeight() * d2)), (boolean)true);
        this.setProgressBarSize(false);
    }

    public int getTmcBarBgPosX() {
        return this.drawTmcBarBgX;
    }

    public int getTmcBarBgPosY() {
        return this.drawTmcBarBgY;
    }

    public int getTmcBarBgWidth() {
        return this.tmcBarBgWidth;
    }

    public int getTmcBarBgHeight() {
        return this.tmcBarBgHeight;
    }

    public void recycleResource() {
        if (this.displayingBitmap != null) {
            this.displayingBitmap.recycle();
            this.displayingBitmap = null;
        }
        if (this.tmcBarBitmapPortrait != null) {
            this.tmcBarBitmapPortrait.recycle();
            this.tmcBarBitmapPortrait = null;
        }
        if (this.tmcBarBitmapLandscape != null) {
            this.tmcBarBitmapLandscape.recycle();
            this.tmcBarBitmapLandscape = null;
        }
    }
}

