/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.android.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.ta.utdid2.android.utils.DebugUtils;
import com.ta.utdid2.android.utils.StringUtils;

public class NetworkUtils {
    public static final String WIFI = "Wi-Fi";
    public static final String DEFAULT_WIFI_ADDRESS = "00-00-00-00-00-00";
    private static final String TAG = "NetworkUtils";
    private static ConnectivityManager sConnManager = null;
    private static final int[] WEAK_NETWORK_GROUP = new int[]{4, 7, 2, 1};

    public static boolean isConnected(Context context) {
        ConnectivityManager connManager = NetworkUtils.getConnManager(context);
        if (connManager != null) {
            try {
                NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    return networkInfo.isConnected();
                }
            }
            catch (Exception e2) {
                Log.e((String)TAG, (String)e2.toString());
            }
        } else {
            Log.e((String)TAG, (String)"connManager is null!");
        }
        return false;
    }

    public static boolean isConnectedToWeakNetwork(Context context) {
        block7: {
            ConnectivityManager connManager = NetworkUtils.getConnManager(context);
            if (connManager != null) {
                try {
                    NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
                    if (networkInfo != null) {
                        int subType = networkInfo.getSubtype();
                        if (DebugUtils.DBG) {
                            Log.d((String)TAG, (String)("subType:" + subType + ": name:" + networkInfo.getSubtypeName()));
                        }
                        for (int element : WEAK_NETWORK_GROUP) {
                            if (element != subType) continue;
                            return true;
                        }
                        break block7;
                    }
                    Log.e((String)TAG, (String)"networkInfo is null!");
                }
                catch (Exception e2) {
                    Log.e((String)TAG, (String)e2.toString());
                }
            } else {
                Log.e((String)TAG, (String)"connManager is null!");
            }
        }
        return false;
    }

    public static ConnectivityManager getConnManager(Context context) {
        if (context == null) {
            Log.e((String)TAG, (String)"context is null!");
            return null;
        }
        if (sConnManager == null) {
            sConnManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
        return sConnManager;
    }

    public static String[] getNetworkState(Context paramContext) {
        String[] arrayOfString = new String[]{"Unknown", "Unknown"};
        try {
            PackageManager localPackageManager = paramContext.getPackageManager();
            if (localPackageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", paramContext.getPackageName()) != 0) {
                arrayOfString[0] = "Unknown";
                return arrayOfString;
            }
            ConnectivityManager localConnectivityManager = (ConnectivityManager)paramContext.getSystemService("connectivity");
            if (localConnectivityManager == null) {
                arrayOfString[0] = "Unknown";
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo1 = localConnectivityManager.getNetworkInfo(1);
            if (localNetworkInfo1 != null && localNetworkInfo1.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = WIFI;
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo2 = localConnectivityManager.getNetworkInfo(0);
            if (localNetworkInfo2 != null && localNetworkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = "2G/3G";
                arrayOfString[1] = localNetworkInfo2.getSubtypeName();
                return arrayOfString;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayOfString;
    }

    public static String getWifiAddress(Context context) {
        if (context != null) {
            WifiManager wifimanage = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiinfo = wifimanage.getConnectionInfo();
            if (wifiinfo != null) {
                String address = wifiinfo.getMacAddress();
                if (StringUtils.isEmpty(address)) {
                    address = DEFAULT_WIFI_ADDRESS;
                }
                return address;
            }
            return DEFAULT_WIFI_ADDRESS;
        }
        return DEFAULT_WIFI_ADDRESS;
    }

    private static String _convertIntToIp(int i2) {
        return (i2 & 0xFF) + "." + (i2 >> 8 & 0xFF) + "." + (i2 >> 16 & 0xFF) + "." + (i2 >> 24 & 0xFF);
    }

    public static String getWifiIpAddress(Context context) {
        if (context != null) {
            try {
                WifiManager wifiManage = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiinfo = wifiManage.getConnectionInfo();
                if (wifiinfo != null) {
                    return NetworkUtils._convertIntToIp(wifiinfo.getIpAddress());
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isWifi(Context context) {
        if (context != null) {
            try {
                if (NetworkUtils.getNetworkState(context)[0].equals(WIFI)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

